#ifndef CAN_COM_H
#define CAN_COM_H

#include "../structs.h"
#include "user_config.h"
#include "mbed.h"
#include "../math_ops.h"

#define P_MIN 0.0f
#define P_MAX 6.283185f //359.9999 deg
//#define P_REPLY_MIN -21360*2*PI
//#define P_REPLY_MAX 21360*2*PI //rad
#define P_REPLY_MIN -15*2*PI 
#define P_REPLY_MAX 15*2*PI //rad

//#define P_MIN -95.5f
//#define P_MAX 95.5f

#define V_MIN -45.0f
#define V_MAX 45.0f
#define KP_MIN 0.0f
#define KP_MAX 500.0f
#define KI_MIN 0.0f
#define KI_MAX 10.0f
#define KD_MIN 0.0f
#define KD_MAX 5.0f
#define T_MIN -20.0f
#define T_MAX 20.0f

//void pack_reply(CANMessage *msg, float p, float v, float t, int version, int calibrate_finish, int state);
void pack_reply(CANMessage *msg, float p, float v, float t, int version, int calibrate_finish, int state, float iq_ref);
void unpack_cmd(CANMessage msg, ControllerStruct * controller);


#endif