/*
    Copyright (c) 2010 Wimpie
        
    Based on the VBus Protocol Specification see http://goo.gl/HP6ZY 
    and http://hobbyelektronik.org/w/index.php/VBus-Decoder
    
    VBus en Resol are registrated trademarks see http://www.resol.de 

    Permission is hereby granted, free of charge, to any person obtaining a copy
    of this software and associated documentation files (the "Software"), to deal
    in the Software without restriction, including without limitation the rights
    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
    copies of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following conditions:

    The above copyright notice and this permission notice shall be included in
    all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
    THE SOFTWARE.
*/

#ifndef VBUS_H
#define VBUS_H

#define Sync  0xAA  // Synchronisation bytes
#define FLength 6  // Framelength
#define FOffset 10 // Offset start of Frames
#define FSeptet 4  // Septet byte in Frame
#define ResolAddress 0x3271  //   ConergyDT5 (0x3271) Address of the controller 
#define SENSORNOTCONNECTED 8888

#include "mbed.h"

/** @defgroup API The VBus API */

/** VBus module
 *
 * Example:
 * @code
 * #include "mbed.h"
 * #include "VBus.h"
 *
 * Serial pc(USBTX, USBRX);
 * VBus ResolBS(NC, p10);
 *
 * int main() {
 *
 *     while(1){
 *         if (ResolBS.Read()) {
 *
 *             pc.printf("T collector = %.1f\r\n",ResolBS.Sensor1_temp);
 *             pc.printf("T store     = %.1f\r\n",ResolBS.Sensor2_temp);
 *             pc.printf("T3          = %.1f\r\n",ResolBS.Sensor3_temp);
 *             pc.printf("T4          = %.1f\r\n",ResolBS.Sensor4_temp);
 *         }
 *     }
 * }
 * @endcode
 */

class VBus {
public:
    //! VBus constructor.
    /**
     * The VBus constructor is used to initialise the VBus object.
     *
     * @param tx The TX pin is NOT connected
     * @param rx The RX pin is connected to p10 or p14 or p27.
     */

    VBus(PinName tx, PinName rx);
    /**
    * The VBus destructor
    */
   // virtual ~VBus();

   
    /**
      * Read 
      * Reads all the device parameters (Sensors, Pumpspeed, RelaisMask)
      **/
    bool Read();
     /**
      * SaveToSDcard
      * Saves the device parameters to a textfile /sd/vb20110101.txt 
      **/
    void SaveToSDcard(char* datetime, char* date,char* dayfn);
    void SDcardAvailable(bool status);
    /**
      * ClearMax
      * Clears the maximum values 
      **/
    void ClearMax();
    
     uint16_t networkaddress;
    float Sensor1_temp;
    float Sensor2_temp;
    float Sensor3_temp;
    float Sensor4_temp;

    float Sensor1_temp_max;
    float Sensor2_temp_max;
    float Sensor3_temp_max;
    float Sensor4_temp_max;

    char PumpSpeed1;  // in  %
    char PumpSpeed2;  //  in %
    char RelaisMask;
    char ErrorMask;
    uint16_t SystemTime;
    char Scheme;
    char OptionPostPulse;
    char OptionThermostat;
    char OptionHQM;
    uint16_t OperatingHoursRelais1;
    uint16_t OperatingHoursRelais2;
    uint32_t HeatQuantity;
    uint16_t Version;
    uint16_t OperatingHoursRelais1Today;

protected:
    Serial _Serial;

private:

    unsigned char Buffer[80];
    volatile unsigned char Bufferlength;

    unsigned int Destination_address ;
    unsigned int Source_address;
    unsigned char ProtocolVersion;
    unsigned int Command ;
    unsigned char Framecnt ;
    unsigned char Septet ;
    unsigned char Checksum ;

    float m_timeout;
    Timer m_timer;

    bool _sdcard;
    bool _all;

    void Init(int addr);
    void InjectSeptet(unsigned char *Buffer, int Offset, int Length);
    void FrameOutput (void);
    void make_Header (unsigned int DAdr,unsigned int SAdr,unsigned char Ver,unsigned int Cmd,unsigned char AFrames);

};
#endif





