/*
* OneWireEEPROM testprogram 
*
* DS2433
* DS28EC20
*
* Copyright (C) <2011> Wim De Roeve <wim312@gmail.com>
*
* OneWireEEPROM is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* OneWireEEPROM is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* If not, see <http://www.gnu.org/licenses/>.
*/

#include "mbed.h"
#include "OneWireEEPROM.h"

Serial output1(USBTX, USBRX);

// EEPROM memorypointers
#define MEM1  0
#define MEM2  MEM1+2
#define MEM3  MEM2+2
#define MEM4  MEM3+1

// unique 1-wire serialkey
// fill RCE1 with you 1 wire serialkey

unsigned char RCE1[8]={0x43,0x8D,0x00,0x00,0x00,0x00,0x00,0x00};

//              device(mbed pin, crcOn, useAddress, parasitic, type    ,ROM code)
OneWireEEPROM  EEPROM1(p21     , false, true,       false    ,DS2433   ,RCE1);

void init_EEPROM() {

    int it=0;
    bool ok=false;

    do {
        it++;
        ok=EEPROM1.Initialize();
    } while ((it<3) and (!ok));

}

int main() {

    uint8_t b1=10;
    uint8_t b2=255;
    int16_t w1=16000;
    int16_t w2=9876;

    init_EEPROM();
    
    output1.printf("\r\n b1=%d, b2=%d, w1=%d, w2=%d",b1,b2,w1,w2);

    if (EEPROM1.active) {
       output1.printf("\r\n writing to EEPROM...");
        EEPROM1.WriteWord(w1 ,MEM1);  // w1 is 2 bytes
        EEPROM1.WriteWord(w2 ,MEM2);  // w2 is 2 bytes
        EEPROM1.WriteByte(b1 ,MEM3);  // b1 is 1 byte
        EEPROM1.WriteByte(b2 ,MEM4);  // b2 is 1 byte
    }

    b1=0;
    b2=0;
    w1=0;
    w2=0;
    
    output1.printf("\r\n clearing values...");
    output1.printf("\r\n b1=%d, b2=%d, w1=%d, w2=%d",b1,b2,w1,w2);

    if (EEPROM1.active) {
        output1.printf("\r\n reading from EEPROM...");
        w1=EEPROM1.ReadWord(MEM1);
        w2=EEPROM1.ReadWord(MEM2);
        b1=EEPROM1.ReadWord(MEM3);
        b2=EEPROM1.ReadWord(MEM4);
    }
    
    output1.printf("\r\n b1=%d, b2=%d, w1=%d, w2=%d",b1,b2,w1,w2);
}
