#include "mbed.h"
#include "DebouncedIn.h"
#include "TextLCD.h"

TextLCD lcd(PTB10, PTB11, PTE2, PTE3, PTE4, PTE5); //Puertos LCD rs, e, d4, d5, d6, d7
 
DigitalOut led1(LED1);      //led de cambio de posición
DigitalOut led2(LED2);      // led incremento de parámetros
DigitalOut led3(LED3);      // led decremento de parámetros
DebouncedIn bot1(PTC12);    //cambiar la posición
DebouncedIn bot2(PTC13);    //incrementar variable
DebouncedIn bot3(PTC16);    //decrementar variable
DebouncedIn bot4(PTC17);    //salida de bucle
  
   //Códigos LCD
int C1=0x0E;            // Muestra el cursor
// 0x18;                // desplazamiento izquierda
// 0x1A;                // desplazamiento derecha
int C4=0x0C;            // Quita el cursor
                     
                     
int a,kp, ki, kd, sp;   // indice y variables del PID


 
int main() {

    led1=led2=led3=1;
    lcd.printf("PARAMETROS PID");
    wait(1.5);
    lcd.cls();
    
    lcd.writeCommand(C1);//comando para mostrar el cursor en el LCD
                       
    lcd.locate(0,0);     // Ubica e imprime nombre de las variables en la LCD
    lcd.printf("Sp=%i",sp);
    lcd.locate(8,0);
    lcd.printf("Kp=%i",kp);
    lcd.locate(0,1);
    lcd.printf("Ki=%i",ki);
    lcd.locate(8,1);
    lcd.printf("Kd=%i",kd);
    
    
    //Inicio del ciclo
        
    while(1) {
           if (bot1.falling()) {      //Aumenta de posición el cursor para cada línea de menu    
               a++;
               led1=0;
               wait(.15); 
               led1=1;
               if (a>3){
               a = 0;
               }   
               switch (a) {
               case 0:
               
               lcd.locate(2,0);
               lcd.printf("=");
               break;
               
               case 1:
               lcd.locate(10,0);
               lcd.printf("=");
               break;
               
               case 2:
               lcd.locate(2,1);
               lcd.printf("=");
               break;
               
               case 3:
               lcd.locate(10,1);
               lcd.printf("=");
               break;
               }
            }
               
                        if  (bot2.falling()) {      //Incrementa el valor del parámetro      
                            led2=0;
                            wait(.15);
                            led2=1;
                            switch (a) {
                            case 0:
               
                            lcd.locate(2,0);
                            lcd.printf("=");
                            lcd.locate(3,0);
                            lcd.printf("%i",++sp);
                            break;
               
                            case 1:
                            lcd.locate(10,0);
                            lcd.printf("=");
                            lcd.locate(11,0);
                            lcd.printf("%i",++kp);
                            break;
               
                            case 2:
                            lcd.locate(2,1);
                            lcd.printf("=");
                            lcd.locate(3,1);
                            lcd.printf("%i",++ki);
                            break;
                            
                            case 3:
                            lcd.locate(10,1);
                            lcd.printf("=");
                            lcd.locate(11,1);
                            lcd.printf("%i",++kd);
                            break;
                    }
               }
               
                                     if   (bot3.falling()) {      //Decrementa el valor del parámetro      
                                     led3=0;
                                     wait(.15);
                                     led3=1;
                                     
                                     switch (a) {
                                     case 0: 
                                      if (sp<0) {                  //No se admite valores negativos
                                      sp=0;
                                     }                                                                                                                               
                                     lcd.locate(2,0);
                                     lcd.printf("=    ");
                                     lcd.locate(3,0);
                                     lcd.printf("%i",sp--);
                                     break;
                                       
                                     case 1:
                                     if (kp<0)  {                 //No se admite valores negativos
                                     kp=0;
                                     }
                                     lcd.locate(10,0);
                                     lcd.printf("=    ");
                                     lcd.locate(11,0);
                                     lcd.printf("%i",kp--);
                                     break;
                                       
                                     case 2:
                                     if (ki<0)  {                 //No se admite valores negativos
                                     ki=0;
                                     }
                                     lcd.locate(2,1);
                                     lcd.printf("=    ");
                                     lcd.locate(3,1);
                                     lcd.printf("%i",ki--);
                                     break;
                                       
                                     case 3:
                                     if (kd<0) {                 //No se admite valores negativos
                                     kd=0;
                                     }
                                     lcd.locate(10,1);
                                     lcd.printf("=    ");
                                     lcd.locate(11,1);
                                     lcd.printf("%i",kd--);
                                     break;
                                }
                          }
                           if (bot4.falling()){
                           led1=led2=led3=0;                                      //Flash para salir del bucle
                           wait(0.25);
                           led1=led2=led3=1;
                           break;                                                 //sale del bucle de la pantalla
                     }
                 }
                  
}
          
                                
           