// Simple Example of use of Threads on mbed OS 5
//   Depreciated use of wait replaced by 'sleep_for'

#include "mbed.h"

// Variable for a second thread
Thread thread;

DigitalOut ledA(LED1); // Red LED
DigitalOut ledB(LED2); // Green LED

// This method is run in the second thread
void ledB_thread() {
    while (true) {
        //wait(0.25); -- depreciated call
        ThisThread::sleep_for(250) ;
        ledB = !ledB;
    }
}

// This is the main thread
int main (void) {
    ledA = 1 ; // off
    ledB = 1 ; // off
    
    // start the second thread
    thread.start(callback(ledB_thread));

    while (true) {
        // wait(0.4); - depreciated call 
        ThisThread::sleep_for(400) ;
        ledA = !ledA;
    }
}
