#include "mbed.h"
#include "wdt.h"

// Sample program using the Watchdog
// ---------------------------------
//    * Watchdog is fed for 5 sec, after that
//    *   ... the system resets 

// Note on how the WATCHDOG is enabled, overloading library function SystemInit
// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
// The KL25Z watchdog is enabled after reset with timeout=1024ms (2^10*LPO=1KHz)
// To make the dvice easy to use on mbed, th watchdog is disabled at startup 
// (in file SystemInit.c) **BUT** SIM_COPC register can only be written once 
// after reset and so it can not be enabled later. To resolve this, 
// SystemInit() is overloaded using:   void $Sub$$SystemInit (void) {
//
// The original SystemInit() can be dowloaded from:
//   https://developer.mbed.org/users/mbed_official/code/mbed-src/
//   navigating to ... targets/cmsis/TARGET_Freescale/TARGET_KLXX/
//                       TARGET_KL25Z/system_MKL25Z4.c
//
// MORE on how this overides the original initialisation: 
//   https://developer.mbed.org/users/chris/notebook/Patching-functions-and-libraries/
//   and searching "ARM Compiler toolchain Using the Linker" 
//      "Using $Super$$ and $Sub$$ to patch symbol definitions"
// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


#define LIGHT 0
#define DARK 1
DigitalOut led_red(LED_RED, LIGHT);
DigitalOut led_blue(LED_BLUE, DARK);

// Demonstate the watchdog
//   The red LED is on after reset
//   The blue LED flashes and the watch dog is fed
//   After 5sec, stop feeding the watchdog
enum wState {Working, Stopped} ;

int main(void) {
    // initialise watchdog
    wdt_1sec() ;
    
    // state of the watch dog
    wState watchDog = Working ;
    int counter = 10 ;
    
    // show start-up
    led_blue = DARK;
    led_red = LIGHT;
    ThisThread::sleep_for(500) ; //wait(0.5) ;
    led_red = DARK;
    
    // Note: the red LED now stays OFF until processor reset
    while(1)
    {
        led_blue = LIGHT;
        ThisThread::sleep_for(250) ; // wait(0.25);
        if (watchDog == Working) wdt_kick_all() ;
        led_blue = DARK;
        ThisThread::sleep_for(250) ; // wait(0.25);
        
        // When the counter reachs zero, change state to stop watchdog 
        if (counter > 0) counter-- ; else watchDog = Stopped ;
    }
}