// Lab 3 Example Program 2
// -----------------------
// Periodically write to the AnalogOut to create a sine wave
// Alternate between two fixed frequencies every 30 sec
// 
// This code uses the Ticker API to create a periodic interrupt
// Devices used in this way must not call locks; a variant of 
//   the AnalogOut device w/o locking is created for this
//
// THIS VERSION HAS DEBUGGING CODE USING THE SERIAL PORT

// Revised for mbed 5

#include "mbed.h"
#include "sineTable.h"

// --------------------------
// This declaration introduces a derived version of the mbed AnalogOut
//   class with the locking removed.
// You do NOT NEED TO UNDERSTAND this 
class AnalogOut_unsafe : public AnalogOut {
  public:
    AnalogOut_unsafe (PinName pin) : AnalogOut (pin) {} 
  protected: 
    virtual void lock() {}
    virtual void unlock() {}
};
// --------------------------

Ticker tick ;          // Creates periodic interrupt
AnalogOut_unsafe ao(PTE30) ;  // Analog output

// --- following code for debugging ---
Thread debugT ;
EventFlags event_flags;
Serial pc(USBTX, USBRX); // tx, rx, useful for debugging

// Put a simple representation of the sine wave
//  to the serial output. ONLY at low frequency
void debug(int index) {
    int sine4 = sine[index] >> 11 ; // get top 5 bits
    pc.putc('*') ;
    while (sine4--) pc.putc('*') ;
    pc.putc('\n') ;
    pc.putc('\r') ;  // depends on the OS being used
}

volatile int index = 0 ; // this variable is not just for debugging!!

void debugCallback() {
    while (true) {
        event_flags.wait_any(0x1) ;
        debug(index) ;  // there is a race condition here
    }
}
// ---- end of debugging code ---------

// Function called periodically
// Write new value to AnalogOut 
void writeAout() {
    ao.write_u16(sine[index]) ;
    event_flags.set(0x1) ; // DEBUGGING low frequency only
    index = (index + 1) % 64 ;   
}

// Control the frequency of updates
//   Alternative between two frequencies      
int main() {
    int update_us = 100000 ; // 100ms
    debugT.start(&debugCallback) ;
    while (true) {
        pc.printf("Update at 64 x 100ms giving about 0.15Hz\n");
        tick.attach_us(callback(&writeAout), update_us); // setup ticker to write to AnalogOut
        ThisThread::sleep_for(30000) ; // wait 30 sec 
        update_us = 150000 ; // 150ms
        pc.printf("Update at 64 x 150ms giving about 0.1Hz\n");
        tick.attach_us(callback(&writeAout), update_us); // setup ticker to write to AnalogOut
        ThisThread::sleep_for(30000) ; // wait 30 sec 
        update_us = 100000 ; // 100ms
    }
}
