// Lab 3 Example Program 2
// -----------------------
// Periodically write to the AnalogOut to create a sine wave
// Alternate between two fixed frequencies every 5 sec
// 
// This code uses the Ticker API to create a periodic interrupt
// Devices used in this way must not call locks; a variant of 
//   the AnalogOut device w/o locking is created for this.
//
// Updated for mbed 5

// THIS VERSION HAS NO DEBUGGING CODE

#include "mbed.h"
#include "sineTable.h"

// --------------------------
// This declaration introduces a derived version of the mbed AnalogOut
//   class with the locking removed.
// You do NOT NEED TO UNDERSTAND this 
class AnalogOut_unsafe : public AnalogOut {
  public:
    AnalogOut_unsafe (PinName pin) : AnalogOut (pin) {} 
  protected: 
    virtual void lock() {}
    virtual void unlock() {}
};
// --------------------------

Ticker tick ;          // Creates periodic interrupt
AnalogOut_unsafe ao(PTE30) ;  // Analog output

// Function called periodically
// Write new value to AnalogOut 
volatile int index = 0 ; // index into array of sin values
void writeAout() {
    ao.write_u16(sine[index]) ;
    index = (index + 1) % 64 ;   
}

// Control the frequency of updates
//   Alternative between two frequencies      
int main() {
    int update_us = 1000 ; // 1ms
    while (true) {
        tick.attach_us(callback(&writeAout), update_us); // setup ticker to write to AnalogOut
        ThisThread::sleep_for(30000) ; // wait 30 sec 
        update_us = 2000 ; // 2ms
        tick.attach_us(callback(&writeAout), update_us); // setup ticker to write to AnalogOut
        ThisThread::sleep_for(30000) ; // wait 30 sec 
        update_us = 1000 ; // 1ms
    }
}
