#include "mbed.h"
#include "MMA8451Q.h"

  PinName const SDA = PTE25;
  PinName const SCL = PTE24;

#define MMA8451_I2C_ADDRESS (0x1d<<1)

int main(void)
{
    MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);
    PwmOut rled(LED1);
    PwmOut gled(LED2);
    PwmOut bled(LED3);
    Serial pc(USBTX, USBRX); // tx, rx


    pc.printf("MMA8451 ID: %d\n", acc.getWhoAmI());

    while (true) {
        float x, y, z;
        x = acc.getAccX();
        y = acc.getAccY();
        z = acc.getAccZ();
        rled = 1.0f - abs(x);
        gled = 1.0f - abs(y);
        bled = 1.0f - abs(z);
        ThisThread::sleep_for(300);  // wait(0.3);
        pc.printf("X: %1.2f, Y: %1.2f, Z: %1.2f\n", x, y, z);
    }
}
