/**
 * A class that runs a terminal to help debug the program. It handles storing
 * received characters in a buffer until a command is read and executing that
 * command.
 * Usage:
 * mts::DebugTerminal* term = new mts::DebugTerminal(dot, UART_TX, UART_RX);
 * term->baud(115200);
 * term->start();
 */
#ifndef DEBUG_TERMINAL_H
#define DEBUG_TERMINAL_H

#include "mDot.h"
#include "MTSSerial.h"
#include "MTSBufferedIO.h"

namespace mts {

class DebugTerminal : public MTSSerial {
public:
    DebugTerminal(mDot* dot, PinName TXD, PinName RXD, int txBufferSize = 256,
            int rxBufferSize = 256);
    virtual ~DebugTerminal();
    
    // Handle terminal reads in a loop
    void start();
    
    // Called after the user presses return.
    // Parameter is a line without \r or \n
    void handleCommand(std::string command);
    
protected:
    
private:
    mDot* dot;
};

} // namespace
#endif // Header guard */
