#include "mbed.h"
#include "mDot.h"
#include "LoraComms.h"
#include "DebugTerminal.h"

Serial pc(USBTX, USBRX); // The serial connection through micro-usb cable
mDot* dot = NULL;
Thread debugTerminalThread;

// Callback function for running a terminal in its own thread
void terminalThreadStarter(mts::DebugTerminal* term) {
    term->start();
}

int main() {
    std::vector<uint8_t> tx_data;
    std::vector<uint8_t> rx_data;
    
    pc.baud(115200);
    pc.printf("Started program\r\n");
    
    dot = initializeLora();
    
    // Create the terminal for the rs232 port and run it in its own thread
    mts::DebugTerminal* debugTerminal = new mts::DebugTerminal(dot, UART_TX, UART_RX);
    debugTerminal->baud(115200);
    debugTerminalThread.start(callback(terminalThreadStarter, debugTerminal));
    
    tx_data.push_back('s');
    tx_data.push_back('c');
    tx_data.push_back('/');
    tx_data.push_back('j');
    
    while (true) {
        // join network if not joined
        if (!dot->getNetworkJoinStatus()) {
            join_network(dot);
        }
        
        // Send what's in tx_data to server and print what's received
        if (dot->send(tx_data) == mDot::MDOT_OK) {
            if (dot->recv(rx_data) == mDot::MDOT_OK) {
                pc.printf("Received data\r\n");
                for (uint8_t i = 0; i < rx_data.size(); ++i) {
                    pc.printf("%c", rx_data[i]);
                }
                pc.printf("\r\n");
                rx_data.clear();
            }
        }
        pc.printf("Waiting\r\n");
        wait(30.f);
    }
}
