/**
 * Code for connecting to network and sending/receiving data
 */

#ifndef LORA_COMMS_H
#define LORA_COMMS_H

#include "mDot.h"
#include "ChannelPlans.h"

/**
 * Create a new mDot instance with channel plan defined in the cpp file, and
 * configure the network name etc. Return the mDot instance.
 * Parameters:
 * radioEvents: A custom event handler to attach to the new mdot instance.
 */
mDot* initializeLora();

/**
 * Print the lora config to debug serial
 */
void display_config(mDot* dot);

/**
 * Update the lora config
 */
void update_ota_config_name_phrase(mDot* dot, std::string network_name, 
        std::string network_passphrase, uint8_t frequency_sub_band,
        lora::NetworkType network_type, uint8_t ack);

/**
 * Update the number of packets to request acks on, and how many lost acks to
 * consider a disconnect
 */
void update_network_link_check_config(mDot* dot, uint8_t link_check_count,
        uint8_t link_check_threshold);

/**
 * Continue attempting to join the network until successful
 */
void join_network(mDot* dot);

#endif
