#include "mbed.h"
#include "DebugTerminal.h"

#define DEFAULT_BAUD 115200

using namespace mts;

DebugTerminal::DebugTerminal(mDot* dot, PinName TXD, PinName RXD,
        int txBufferSize, int rxBufferSize)
        : MTSSerial(TXD, RXD, txBufferSize, rxBufferSize),
        dot(dot)
{
    baud(DEFAULT_BAUD);
}

DebugTerminal::~DebugTerminal() {
    
}

void DebugTerminal::start() {
    writef("DebugTerminal Started\r\n");
    
    std::string command;
    
    while(1) {
        if (readable()) {
            char ch;
            read(ch);
            if (ch == '\n' || ch == '\r') { // handle newline
                writef("\r\n");
                handleCommand(command);
                command.clear();
            } else if (ch == '\b' || ch == 0x7f) { // handle backspace
                if (!command.empty()) {
                    writef("\b \b");
                    command.erase(command.size() - 1);
                }
            } else { // handle regular character
                command += ch;
                write(ch); // echo the char back to terminal
            }
        }
        wait(0.00001);
    }
}

void DebugTerminal::handleCommand(std::string command) {
    if (dot == NULL) {
        writef("Error in DebugTerminal - member 'dot' is uninitialized\r\n");
        return;
    }
    if (command.compare("ni") == 0) {
        writef("Network Name: ");
        writef(dot->getNetworkName().c_str());
        writef("\r\n");
    }
}
