//Binary Counter
#include "mbed.h"

DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);

DigitalIn enable(p5);       //use pin5 as count enable
DigitalIn reset(p6);        //use pin6 as reset

void LedFlash( int Flashes, float delay ) {
    while( Flashes > 0 ) {           
        myled1=0; myled2=0; myled3=0; myled4=0; wait(delay);
        myled1=1; myled2=1; myled3=1; myled4=1; wait(delay);
        Flashes -= 1 ;   
    }
}

void WriteLed( int LedOn) {
    char ONE   = 1;
    char TWO   = 2;
    char FOUR  = 4;
    char EIGHT = 8;
    if ( LedOn & ONE )   myled1 = 1 ; else myled1 = 0 ;
    if ( LedOn & TWO )   myled2 = 1 ; else myled2 = 0 ;
    if ( LedOn & FOUR )  myled3 = 1 ; else myled3 = 0 ;
    if ( LedOn & EIGHT ) myled4 = 1 ; else myled4 = 0 ;
}

int main() {
    char LedOn = 0;
    char MaxCount = 15;
    LedFlash( 10, 0.1 ); 
 
    while(1) {
        wait(0.5); 
        WriteLed( LedOn );
        wait(0.5);
        if ( enable ) {
            LedOn += 1;        
        }
        if ( reset ) {
            LedOn = 0;
        }
        if ( LedOn > MaxCount ) {
            LedFlash( 3, 0.2 ); 
            LedOn = 0 ;
        }    
    }
}



