#ifndef ADC_H_
#define ADC_H_

#include "mbed.h"


class ADS8556 {

public:

	typedef struct {
		double value[6];
	} ADCData;

	ADS8556(SPI *spi, PinName cs, PinName reset, PinName convst, PinName busy);

	void adc(int16_t* data);
	double get(int16_t* data, uint16_t channel, uint16_t num);
	double get2(int16_t* data, uint16_t channel, uint16_t num);

private:
	SPI *_spi;
	DigitalOut _cs;
	DigitalOut _reset;
	DigitalOut _convst;
	DigitalIn _busy;

};

#endif

