#include "MATH1.h"
#define pi  3.14159265359
double round(double src, int n)
{
    double res;
    int i, k = 1;
    for (i = 0; i<n; i++)k *= 10;
    res = int(src*k + 0.5);
    res /= k;
    return res;
}
double mean(double *d, int len)
{
    double mean = 0.0;
    double sum = 0.0;

    for(int i = 0 ; i<len ; i++) {
        sum += d[i];
    }

    mean = sum / len ;
    return mean;
}

double MAXof3(double one, double two, double three)
{
    double MAXMAX = one;
    double yoyoyo[2]= {two, three};
    for(int i = 0; i<2 ; i++) {
        if(yoyoyo[i]>MAXMAX) {
            MAXMAX = yoyoyo[i];
        }
    }
    return MAXMAX;
}

///square///
double MATH::sqr(double value)
{
    double sqrvalue = value * value;
    return sqrvalue;
}


///line voltage RMS///
double MATH::LVRMS(double* d1, double* d2,  uint16_t len)
{
    double sum = 0.0;
    for (int i = 0; i < len; i++) {
        sum += sqr((d1[i]-d2[i]));
    }
    double RMS = sqrt(sum/len);
    return RMS;
}

///RMS///
double MATH::RMS(double* d, uint16_t len)
{
    double sum = 0.0;
    for (int i = 0; i < len; i++) {
        sum += d[i]*d[i];
    }
    double rms = sqrt(sum/len)*1.0;
    return rms;
}

///Voltage Deviation Factor///
double MATH::VDF(double d1, double d2, double d3)
{
    double dmax=0.0;
    double x[3]={fabs((d1-220)/220)*100,fabs((d2-220)/220)*100,fabs((d3-220)/220)*100};
    for(int i=0 ; i<3 ; i++) {
        if(x[i]>dmax) {
            dmax=x[i];
        }
    }
    return dmax;
}
///Currrent Deviation Factor///
double MATH::CDF(double d1, double d2, double d3)
{
    double dmax=0.0;
    double x[3]={d1,d2,d3};
    for(int i=0 ; i<3 ; i++) {
        if(x[i]>dmax) {
            dmax=x[i];
        }
    }
    double CDF=(dmax-6.1)/6.1*100;
    if(CDF<0){CDF=0;}
    return CDF;
}        
///unbalance rate///
double MATH::UR(double d1, double d2, double d3)
{
    double abc_avg = (d1+d2+d3) / 3.0;
    double x[3] = {fabs(d1 - abc_avg), fabs(d2 - abc_avg), fabs(d3 - abc_avg)};
    double dmax = 0.0;
    for(int i=0 ; i<3 ; i++) {
        if(x[i]>dmax) {
            dmax=x[i];
        }
    }
    double URv = dmax / abc_avg * 100.0;
    return URv;
}


///angle(rad)///
double MATH::angle(double d1, double d2)
{

    double sqrt_2 = sqrt(2.0);
    if (d1 > 0.0 ) {
        if(d2 > 0.0) {
            double rad = fabs(atan(d2 / d1));
            return (0.0 + rad);
        } else {
            double rad = fabs(atan(d2 / d1));
            return (0.0 - rad);
        }
    } else {
        if(d2 > 0.0) {
            double rad = fabs(atan(d2 / d1));
            return (pi - rad);
        } else {
            double rad = fabs(atan(d2 / d1));
            return (pi + rad);
        }
    }
}

///Unbalance Factor///
double MATH::UF(double rms_a, double rms_b, double rms_c, double angle_a, double angle_b, double angle_c)
{
    double a = 120.0 * pi / 180 ;      /// degree ->  rad
    double ang_v1_1 = angle_b + a*2.0 ;
    double ang_v1_2 = angle_c + a;
    double ang_v2_1 = angle_b + a;
    double ang_v2_2 = angle_c + a*2.0;

    double v1 = sqrt(sqr((rms_a * cos(angle_a)) + (rms_b * cos(ang_v1_1)) + (rms_c * cos(ang_v1_2)))
                     + sqr((rms_a * sin(angle_a)) + (rms_b * sin(ang_v1_1)) + (rms_c * sin(ang_v1_2))));
    double v2 = sqrt(sqr((rms_a * cos(angle_a)) + (rms_b * cos(ang_v2_1)) + (rms_c * cos(ang_v2_2)))
                     + sqr((rms_a * sin(angle_a)) + (rms_b * sin(ang_v2_1)) + (rms_c * sin(ang_v2_2))));

    return (v2/v1)*100.0 ;
}

///DFT///
double MATH::doDFT(double *input, double *output, int N)
{
    for (int i=0 ; i<N ; i++) {
        double re = 0;
        double im = 0;
        for(int j=0 ; j<N ; j++) {
            re += input[j]*cos(2*pi*i*j/N);
            im += input[j]*(-sin(2*pi*i*j/N));
        }
        output[i] = sqrt(sqr(re) + sqr(im))/N;
    }
    return *output;

}


void MATH::integal(double *in, double *out, int len, int sps)
{

    double t = 1.0 /sps ;
    double  mean1;
    double sum = 0.0;
    out[0] = 0 ;
    double v = 0;

    for(int i = 1 ; i < len ; i++) {
        v += ((in[i - 1] + in[i]) * t / 2.0);       ///   m/s --> *1000 mm/s --> *1000 *1000 um/s
        out[i] = v;
    }

    mean1 = mean(out, len);

    for(int i = 0 ; i<len ; i++) {
        out[i] = ( out[i] - mean1 ) * 1000;
    }


}

void MATH::detrend(double *y, int len, int sps)
{
    int i;
    double t = 1.0 /sps ;

    double sum_k1 = 0.0, sum_k2 = 0.0, xbar = 0.0, ybar = 0.0;

    double *x, *d1, *d2;
    x = (double*) malloc(sizeof(double) * len);
    d1 = (double*) malloc(sizeof(double) * len);
    d2 = (double*) malloc(sizeof(double) * len);

    for(i=0 ; i<len ; i++) {
        x[i] = (i+1)*t;
    }

    xbar = mean(x, len);
    ybar = mean(y, len);

    for(i=0 ; i<len ; i++) {
        d1[i] = x[i]-xbar;
        d2[i] = y[i]-ybar;
        sum_k1 += d1[i]*d2[i];
        sum_k2 += d1[i]*d1[i];
    }
    
    double A,B;
    A = sum_k1/sum_k2;
    B = ybar-A*xbar;

    double * trend;
    trend = (double*) malloc(sizeof(double) * len);

    for(i=0 ; i<len ; i++) {
        trend[i]=A*x[i] + B;
        y[i]=y[i]-trend[i];
    }

}


double MATH::Peak2Peak(double *in, int len)
{
    int i;
    double outpp;

    double MAX = in[0];
    for(i = 1 ; i < len ; i++) {
        MAX = (in[i] > MAX ? in[i]:MAX ) ;
    }

    double min = in[0];
    for(i = 1 ; i < len ; i++) {
        min = (in[i] < min ? in[i]:min ) ;
    }

    outpp = MAX - min;

    return outpp;
}


double MATH::PeakValue(double *x , double *y, double *z, int len)
{
    double xmax = fabs(x[0]), ymax = fabs(y[0]), zmax = fabs(z[0]);
    for(int i =1; i<len ; i++) {
        if(fabs(x[i]) > xmax) {
            xmax = fabs(x[i]);
        }
        if(fabs(y[i]) > ymax) {
            ymax = fabs(y[i]);
        } 
        if(fabs(z[i]) > zmax) {
            zmax = fabs(z[i]);
        }
    }
    double MAX = ymax;
    double xzmax[2]= {xmax, zmax};
    for(int i=0 ; i<2 ; i++) {
        if(xzmax[i] > MAX) {
            MAX = xzmax[i];
        }
    }

    return MAX ;
}


double MATH::UBValue(double *maxi, double *x , double *y, double *z, int len)
{
    double xmin = fabs(x[0]) , ymin = fabs(y[0]) , zmin = fabs(z[0]);
    for(int i = 1 ; i<len ; i++) {
        if(fabs(x[i]) < xmin) {
            xmin = fabs(x[i]);
        }
        if(fabs(y[i]) < ymin) {
            ymin = fabs(y[i]);
        }
        if(fabs(z[i]) < zmin) {
            zmin = fabs(z[i]);
        }
    }
    double MIN = zmin;
    double yxmin[2]= {ymin, xmin};
    for(int i=0 ; i<2 ; i++) {
        if(yxmin[i] < MIN) {
            MIN = yxmin[i];
        }
    }

    double UB = *maxi + 0.5 *( *maxi - MIN ) / ( len - 1 );
    return UB;
}


double MATH::THD(double *ass_1, double *ass_2, double *ass_3, int pu)
{
    double WTF, WTFa, WTFb, WTFc;
    double you_1=0, you_2=0, you_3=0, fu_1, fu_2, fu_3;
    int i=0;

    switch(pu) {
        case 10000 :
        
            for(i=0;i<10;i++){you_1  = you_1+sqr(ass_1[120+i*60]);} 
            fu_1 = sqrt(you_1);
            WTFa  = (fu_1 / ass_1[60])*100;

            for(i=0;i<10;i++){you_2  = you_2+sqr(ass_2[120+i*60]);} 
            fu_2 = sqrt(you_2);
            WTFb  = (fu_2 / ass_2[60])*100;

            for(i=0;i<10;i++){you_3  = you_3+sqr(ass_3[120+i*60]);} 
            fu_3 = sqrt(you_3);
            WTFc  = (fu_3 / ass_3[60])*100;

            WTF = MAXof3(WTFa, WTFb, WTFc);
            break;
        case 8192 :

            double opps_2, opps_3, opps_4, opps_5, opps_6, opps_7, opps_8, opps_9, opps_10, opps_11;

            opps_2 = (ass_1[49] > ass_1[50] ? ass_1[49] :ass_1[50]);
            opps_4 = (ass_1[98] > ass_1[99] ? ass_1[98] :ass_1[99]);
            opps_6 = (ass_1[147] > ass_1[148] ? ass_1[147] :ass_1[148]);
            opps_7 = (ass_1[172] > ass_1[173] ? ass_1[172] :ass_1[173]);
            opps_9 = (ass_1[221] > ass_1[222] ? ass_1[221] :ass_1[222]);
            opps_11 = (ass_1[270] > ass_1[271] ? ass_1[270] :ass_1[271]);
            opps_3 = MAXof3(ass_1[73], ass_1[74], ass_1[75]);
            opps_5 = MAXof3(ass_1[122], ass_1[123], ass_1[124]);
            opps_8 = MAXof3(ass_1[196], ass_1[197], ass_1[198]);
            opps_10 = MAXof3(ass_1[245], ass_1[246], ass_1[247]);

            you_1  = (sqr(opps_2) + sqr(opps_3) + sqr(opps_4) + sqr(opps_5) + sqr(opps_6) + sqr(opps_7) + sqr(opps_8) + sqr(opps_9) + sqr(opps_10) + sqr(opps_11));
            fu_1 = sqrt(you_1);
            WTFa  = (fu_1 / ass_1[24])*100;

            opps_2 = (ass_2[49] > ass_2[50] ? ass_2[49] :ass_2[50]);
            opps_4 = (ass_2[98] > ass_2[99] ? ass_2[98] :ass_2[99]);
            opps_6 = (ass_2[147] > ass_2[148] ? ass_2[147] :ass_2[148]);
            opps_7 = (ass_2[172] > ass_2[173] ? ass_2[172] :ass_2[173]);
            opps_9 = (ass_2[221] > ass_2[222] ? ass_2[221] :ass_2[222]);
            opps_11 = (ass_2[270] > ass_2[271] ? ass_2[270] :ass_2[271]);
            opps_3 = MAXof3(ass_2[73], ass_2[74], ass_2[75]);
            opps_5 = MAXof3(ass_2[122], ass_2[123], ass_2[124]);
            opps_8 = MAXof3(ass_2[196], ass_2[197], ass_2[198]);
            opps_10 = MAXof3(ass_2[245], ass_2[246], ass_2[247]);

            you_2  = (sqr(opps_2) + sqr(opps_3) + sqr(opps_4) + sqr(opps_5) + sqr(opps_6) + sqr(opps_7) + sqr(opps_8) + sqr(opps_9) + sqr(opps_10) + sqr(opps_11));
            fu_2 = sqrt(you_2);
            WTFb  = (fu_2 / ass_2[24])*100;

            opps_2 = (ass_3[49] > ass_3[50] ? ass_3[49] :ass_3[50]);
            opps_4 = (ass_3[98] > ass_3[99] ? ass_3[98] :ass_3[99]);
            opps_6 = (ass_3[147] > ass_3[148] ? ass_3[147] :ass_3[148]);
            opps_7 = (ass_3[172] > ass_3[173] ? ass_3[172] :ass_3[173]);
            opps_9 = (ass_3[221] > ass_3[222] ? ass_3[221] :ass_3[222]);
            opps_11 = (ass_3[270] > ass_3[271] ? ass_3[270] :ass_3[271]);
            opps_3 = MAXof3(ass_3[73], ass_3[74], ass_3[75]);
            opps_5 = MAXof3(ass_3[122], ass_3[123], ass_3[124]);
            opps_8 = MAXof3(ass_3[196], ass_3[197], ass_3[198]);
            opps_10 = MAXof3(ass_3[245], ass_3[246], ass_3[247]);

            you_3  = (sqr(opps_2) + sqr(opps_3) + sqr(opps_4) + sqr(opps_5) + sqr(opps_6) + sqr(opps_7) + sqr(opps_8) + sqr(opps_9) + sqr(opps_10) + sqr(opps_11));
            fu_3 = sqrt(you_3);
            WTFc  = (fu_3 / ass_3[24])*100;

            WTF = MAXof3(WTFa, WTFb, WTFc);
            break;
    }

    return WTF;
}


double MATH::HD(double *ck_1, double *ck_2, double *ck_3, int pu)
{
    double blow, blow1, blow2, blow3;
    double su_3, su_5, su_7, su_9, su_11;

    switch(pu) {

        case 10000:

            su_3 = (ck_1[180] / ck_1[60])*100;
            su_5 = (ck_1[300] / ck_1[60])*100;
            su_7 = (ck_1[420] / ck_1[60])*100;
            su_9 = (ck_1[540] / ck_1[60])*100;
            su_11 = (ck_1[660] / ck_1[60])*100;

            blow1 = su_3;
            //double job[4]= {su_5, su_7, su_9, su_11};
            //for(int i = 0 ; i<4 ; i++) {
            //    if(job[i] > blow1) {
            //        blow1 = job[i];
            //    }
            //}

            su_3 = (ck_2[180] / ck_2[60])*100;
            su_5 = (ck_2[300] / ck_2[60])*100;
            su_7 = (ck_2[420] / ck_2[60])*100;
            su_9 = (ck_2[540] / ck_2[60])*100;
            su_11 = (ck_2[660] / ck_2[60])*100;

            blow2 = su_3;
            //double job2[4]= {su_5, su_7, su_9, su_11};
            //for(int i = 0 ; i<4 ; i++) {
            //    if(job2[i] > blow2) {
            //        blow2 = job2[i];
            //    }
            //}

            su_3 = (ck_3[180] / ck_3[60])*100;
            su_5 = (ck_3[300] / ck_3[60])*100;
            su_7 = (ck_3[420] / ck_3[60])*100;
            su_9 = (ck_3[540] / ck_3[60])*100;
            su_11 = (ck_3[660] / ck_3[60])*100;

            blow3 = su_3;
            //double job3[4]= {su_5, su_7, su_9, su_11};
            //for(int i = 0 ; i<4 ; i++) {
            //    if(job3[i] > blow3) {
            //        blow3 = job3[i];
            //    }
            //}

            blow = MAXof3(blow1, blow2, blow3);

            break;

        case 8192 :

            double opps_3, opps_5, opps_7, opps_9, opps_11;
            opps_3 = MAXof3(ck_1[73], ck_1[74], ck_1[75]);
            opps_5 = MAXof3(ck_1[122], ck_1[123], ck_1[124]);
            opps_7 = (ck_1[172] > ck_1[173] ? ck_1[172] :ck_1[173]);
            opps_9 = (ck_1[221] > ck_1[222] ? ck_1[221] :ck_1[222]);
            opps_11 = (ck_1[270] > ck_1[271] ? ck_1[270] :ck_1[271]);


            su_3 = (opps_3 / ck_1[24])*100;
            su_5 = (opps_5 / ck_1[24])*100;
            su_7 = (opps_7 / ck_1[24])*100;
            su_9 = (opps_9 / ck_1[24])*100;
            su_11 = (opps_11 / ck_1[24])*100;

            blow1 = su_3;
            double job4[4]= {su_5, su_7, su_9, su_11};
            for(int i = 0 ; i<4 ; i++) {
                if(job4[i] > blow1) {
                    blow1 = job4[i];
                }
            }


            opps_3 = MAXof3(ck_2[73], ck_2[74], ck_2[75]);
            opps_5 = MAXof3(ck_2[122], ck_2[123], ck_2[124]);
            opps_7 = (ck_2[172] > ck_2[173] ? ck_2[172] :ck_2[173]);
            opps_9 = (ck_2[221] > ck_2[222] ? ck_2[221] :ck_2[222]);
            opps_11 = (ck_2[270] > ck_2[271] ? ck_2[270] :ck_2[271]);

            su_3 = (opps_3 / ck_2[24])*100;
            su_5 = (opps_5 / ck_2[24])*100;
            su_7 = (opps_7 / ck_2[24])*100;
            su_9 = (opps_9 / ck_2[24])*100;
            su_11 = (opps_11 / ck_2[24])*100;

            blow2 = su_3;
            double job5[4]= {su_5, su_7, su_9, su_11};

            for(int i = 0 ; i<4 ; i++) {
                if(job5[i] > blow2) {
                    blow2 = job5[i];
                }
            }


            opps_3 = MAXof3(ck_3[73], ck_3[74], ck_3[75]);
            opps_5 = MAXof3(ck_3[122], ck_3[123], ck_3[124]);
            opps_7 = (ck_3[172] > ck_3[173] ? ck_3[172] :ck_3[173]);
            opps_9 = (ck_3[221] > ck_3[222] ? ck_3[221] :ck_3[222]);
            opps_11 = (ck_3[270] > ck_3[271] ? ck_3[270] :ck_3[271]);

            su_3 = (opps_3 / ck_3[24])*100;
            su_5 = (opps_5 / ck_3[24])*100;
            su_7 = (opps_7 / ck_3[24])*100;
            su_9 = (opps_9 / ck_3[24])*100;
            su_11 = (opps_11 / ck_3[24])*100;

            blow3 = su_3;
            double job6[4]= {su_5, su_7, su_9, su_11};

            for(int i = 0 ; i<4 ; i++) {
                if(job6[i] > blow3) {
                    blow3 = job6[i];
                }
            }

            blow = MAXof3(blow1, blow2, blow3);

            break;
    }

    return blow;

}
double MATH::BB(double *d1, double *d2, double *d3, int pu)
{
   switch(pu){
      case 10000:
   
          double x[3]={d1[59], d1[60], d1[61]}, y[3]={d2[59], d2[60], d2[61]}, z[3]={d3[59], d3[60], d3[61]};
          double x_1[3]={d1[65], d1[66], d1[67]}, y_1[3]={d2[65], d2[66], d2[67]}, z_1[3]={d3[65], d3[66], d3[67]};
          double x_2[3]={d1[53], d1[54], d1[55]}, y_2[3]={d2[53], d2[54], d2[55]}, z_2[3]={d3[53], d3[54], d3[55]};
          int i=0;double tmp1=0,tmp2=0,tmp3=0,tmp1_1=0,tmp2_1=0,tmp3_1=0,tmp1_2=0,tmp2_2=0,tmp3_2=0;
          for(i=0;i<3;i++){if(x[i]>tmp1)tmp1=x[i];}
          for(i=0;i<3;i++){if(y[i]>tmp2)tmp2=y[i];}
          for(i=0;i<3;i++){if(z[i]>tmp3)tmp3=z[i];}
          for(i=0;i<3;i++){if(x_1[i]>tmp1_1)tmp1_1=x_1[i];}
          for(i=0;i<3;i++){if(y_1[i]>tmp2_1)tmp2_1=y_1[i];}
          for(i=0;i<3;i++){if(z_1[i]>tmp3_1)tmp3_1=z_1[i];}
          for(i=0;i<3;i++){if(x_2[i]>tmp1_2)tmp1_2=x_2[i];}
          for(i=0;i<3;i++){if(y_2[i]>tmp2_2)tmp2_2=y_2[i];}
          for(i=0;i<3;i++){if(z_2[i]>tmp3_2)tmp3_2=z_2[i];}
          double n[3],ra=0,rb=0,rc=0,la=0,lb=0,lc=0,BB=-50;
          for(i=0;i<2;i++){n[i]=x_1[i]-x_1[i+1];if(n[i]<ra)ra=n[i];}
          for(i=0;i<2;i++){n[i]=y_1[i]-y_1[i+1];if(n[i]<rb)rb=n[i];}
          for(i=0;i<2;i++){n[i]=z_1[i]-z_1[i+1];if(n[i]<rc)rc=n[i];}
          for(i=0;i<2;i++){n[i]=x_2[i+1]-x_2[i];if(n[i]<la)la=n[i];}
          for(i=0;i<2;i++){n[i]=y_2[i+1]-y_2[i];if(n[i]<lb)lb=n[i];}
          for(i=0;i<2;i++){n[i]=z_2[i+1]-z_2[i];if(n[i]<lc)lc=n[i];}
          if(ra<-0.02 || la<-0.02){n[0]=20*log10((tmp1_1+tmp1_2)/tmp1);} else {n[0]=-50;}
          if(rb<-0.02 || lb<-0.02){n[1]=20*log10((tmp2_1+tmp2_2)/tmp2);} else {n[1]=-50;}
          if(rc<-0.02 || lc<-0.02){n[2]=20*log10((tmp3_1+tmp3_2)/tmp3);} else {n[2]=-50;}
          for(i=0;i<3;i++){if(n[i]>BB)BB=n[i];}
          return BB;
   
          break;
        case 8192:
   
          double xx[3]={d1[23], d1[24], d1[25]}, yy[3]={d2[23], d2[24], d2[25]}, zz[3]={d3[23], d3[24], d3[25]};
          double xx_1[3]={d1[25], d1[26], d1[27]}, yy_1[3]={d2[25], d2[26], d2[27]}, zz_1[3]={d3[25], d3[26], d3[27]};
          double xx_2[3]={d1[21], d1[22], d1[23]}, yy_2[3]={d2[21], d2[22], d2[23]}, zz_2[3]={d3[21], d3[22], d3[23]};
          double ttmp1=0,ttmp2=0,ttmp3=0,ttmp1_1=0,ttmp2_1=0,ttmp3_1=0,ttmp1_2=0,ttmp2_2=0,ttmp3_2=0;
          for(i=0;i<3;i++){if(xx[i]>ttmp1)ttmp1=xx[i];}
          for(i=0;i<3;i++){if(yy[i]>ttmp2)ttmp2=yy[i];}
          for(i=0;i<3;i++){if(zz[i]>ttmp3)ttmp3=zz[i];}
          for(i=0;i<3;i++){if(xx_1[i]>ttmp1_1)ttmp1_1=xx_1[i];}
          for(i=0;i<3;i++){if(yy_1[i]>ttmp2_1)ttmp2_1=yy_1[i];}
          for(i=0;i<3;i++){if(zz_1[i]>ttmp3_1)ttmp3_1=zz_1[i];}
          for(i=0;i<3;i++){if(xx_2[i]>ttmp1_2)ttmp1_2=xx_2[i];}
          for(i=0;i<3;i++){if(yy_2[i]>ttmp2_2)ttmp2_2=yy_2[i];}
          for(i=0;i<3;i++){if(zz_2[i]>ttmp3_2)ttmp3_2=zz_2[i];}
          double nn[3],rra=0,rrb=0,rrc=0,lla=0,llb=0,llc=0,BBB=-50;
          for(i=0;i<3;i++){nn[i]=xx_1[i]-xx_1[i+1];if(nn[i]<rra)rra=nn[i];}
          for(i=0;i<3;i++){nn[i]=yy_1[i]-yy_1[i+1];if(nn[i]<rrb)rrb=nn[i];}
          for(i=0;i<3;i++){nn[i]=zz_1[i]-zz_1[i+1];if(nn[i]<rrc)rrc=nn[i];}
          for(i=0;i<3;i++){nn[i]=xx_2[i+1]-xx_2[i];if(nn[i]<lla)lla=nn[i];}
          for(i=0;i<3;i++){nn[i]=yy_2[i+1]-yy_2[i];if(nn[i]<llb)llb=nn[i];}
          for(i=0;i<3;i++){nn[i]=zz_2[i+1]-zz_2[i];if(nn[i]<llc)llc=nn[i];}
          if(rra<-0.02 || lla<-0.02){nn[0]=20*log10((ttmp1_1+ttmp1_2)/ttmp1);} else {nn[0]=-50;}
          if(rrb<-0.02 || llb<-0.02){nn[1]=20*log10((ttmp2_1+ttmp2_2)/ttmp2);} else {nn[1]=-50;}
          if(rrc<-0.02 || llc<-0.02){nn[2]=20*log10((ttmp3_1+ttmp3_2)/ttmp3);} else {nn[2]=-50;}
          for(i=0;i<3;i++){if(nn[i]>BB)BB=nn[i];}
          return BB;
         break;
   }
}
void MATH::Fuzzy_Fault(double IUR,double IUF,double THDV,double VDFodd,double THDI,double IDFodd,double BB,double peakvalue,double *health,double *stator,double *rotor,double *bearing, double *eccentric)
{  
   double h[8],f1[8],s[7],r[7],b[6],e[6],h1max=0,f1max=0,g1max=0,g2max=0,rmax=0,bmax=0,smax=0,emax=0; int i=0;
   h[0]=IUR*1.0/8.0-1.0/4.0;if(h[0]<0){h[0]=0;}if(h[0]>1){h[0]=1;}
   h[1]=IUF*2.0-4.0;if(h[1]<0){h[1]=0;}if(h[1]>1){h[1]=1;}
   h[2]=THDV*(1.0/3.0)-2.0/3.0;if(h[2]<0){h[2]=0;}if(h[2]>1){h[2]=1;}
   h[3]=VDFodd*2.0/5.0-1.0/5.0;if(h[3]<0){h[3]=0;}if(h[3]>1){h[3]=1;}
   h[4]=THDI*2.0/5.0-1.0;if(h[4]<0){h[4]=0;}if(h[4]>1){h[4]=1;}
   h[5]=IDFodd*1.0/3.0-1.0/3.0;if(h[5]<0){h[5]=0;}if(h[5]>1){h[5]=1;}
   h[6]=BB*1.0/5.0+9.0;if(h[6]<0){h[6]=0;}if(h[6]>1){h[6]=1;}
   h[7]=peakvalue*2.0-8.0;if(h[7]<0){h[7]=0;}if(h[7]>1){h[7]=1;}
   if(h[0]==0&&h[1]==0&&h[2]==0&&h[3]==0&&h[4]==0&&h[5]==0&&h[6]==0&&h[7]==0){*health=100;*stator=0;*rotor=0;*bearing=0;*eccentric=0;}
   else{
   for(i=0;i<8;i++){f1[i]=h[i];if(h[i]>f1max){f1max=h[i];}}
   h1max=1-f1max;
   *health=h1max*100;
   g2max=h[7];g1max=1-g2max;
   s[0]=h[0]*0.987*0.6;r[0]=h[0]*0.013*0.6;s[1]=h[1];r[1]=0;s[2]=h[2]*0.242*0.6;r[2]=h[2]*0.758*0.6;s[3]=h[3]*0.24*0.6;r[3]=h[3]*0.76*0.6;s[4]=h[4]*0.383*0.6;r[4]=h[4]*0.617*0.6;s[5]=h[5]*0.44*0.6;r[5]=h[5]*0.56*0.6;
   r[6]=h[6];s[6]=0;if(r[6]==0){s[6]=1.0;}
   for(i=0;i<7;i++){if(s[i]>smax){smax=s[i];}if(r[i]>rmax)rmax=r[i];}
   rmax=rmax/(smax+rmax);smax=1-rmax;*stator=f1max*g1max*smax*100;*rotor=f1max*g1max*rmax*100;
   b[0]=h[0]*0.025*0.6;e[0]=h[0]*0.975*0.6;b[1]=0;e[1]=h[1];b[2]=h[2]*0.797*0.6;e[2]=h[2]*0.203*0.6;b[3]=h[3]*0.839*0.6;e[3]=h[3]*0.161*0.6;b[4]=h[4]*0.722*0.6;e[4]=h[4]*0.278*0.6;b[5]=h[5]*0.764*0.6;e[5]=h[5]*0.236*0.6;
   for(i=0;i<6;i++){if(b[i]>bmax){bmax=b[i];}if(e[i]>emax)emax=e[i];}
   emax=emax/(bmax+emax);bmax=1-emax;*bearing=f1max*g2max*bmax*100;*eccentric=f1max*g2max*emax*100;
   }
}   
void MATH::Fuzzy_Condition(double VUR,double IUR,double VUF,double IUF,double VD,double CD,double Vel,double Dis,double *pCMS)
{
  double g1[2],g2[2],g3[2],g4[2],g5[2],c1[9]={0},c2[9]={0},p[2];
  int flag1,flag2,flag3,flag4,flag5,i;
  if(VUR>=5||IUR>=10||VD>=10||CD>=10||Vel>=4.5||VUF>=1||IUF>=2.5||Dis>=90){*pCMS=1;}
  else if(VUR<=1&&IUR<=2&&VD<=2.5&&CD==0&&Vel<=0.7){*pCMS=0;}
  else{
        if(VUR<=2){g1[1]=VUR-1.0;if(g1[1]<0){g1[1]=0;}g1[0]=1-g1[1];flag1=1;}
        if(VUR>2&&VUR<=3.5){g1[1]=VUR*2.0/3.0-4.0/3.0;g1[0]=1-g1[1];flag1=2;}
        if(VUR>3.5&&VUR<5){g1[1]=VUR*2.0/3.0-7.0/3.0;g1[0]=1-g1[1];flag1=3;}
        if(IUR<=4){g2[1]=IUR*0.5-1;if(g2[1]<0){g2[1]=0;}g2[0]=1-g2[1];flag2=1;}
        if(IUR>4&&IUR<=6){g2[1]=IUR*0.5-2.0;g2[0]=1-g2[1];flag2=2;}
        if(IUR>6&&IUR<10){g2[1]=IUR*0.25-3.0*2.0;g2[0]=1-g2[1];flag2=3;}
        if(VD<=3){g3[1]=VD*2.0-5.0;if(g3[1]<0){g3[1]=0;}g3[0]=1-g3[1];flag3=1;}
        if(VD>3&&VD<=5){g3[1]=VD*0.5-3.0/2.0;g3[0]=1-g3[1];flag3=2;}
        if(VD>5&&VD<10){g3[1]=VD*0.2-1.0;g3[0]=1-g3[1];flag3=3;}
        if(CD<=2){g4[1]=CD*0.5;if(g4[1]<0){g4[1]=0;}g4[0]=1-g4[1];flag4=1;}
        if(CD>2&&CD<=5){g4[1]=CD*1.0/3.0-2.0/3.0;g4[0]=1-g4[1];flag4=2;}
        if(CD>5&&CD<10){g4[1]=CD*0.2-1.0;g4[0]=1-g4[1];flag4=3;}
        if(Vel<=0.7){g5[1]=Vel*10.0/7.0;if(g5[1]<0){g5[1]=0;}g5[0]=1-g5[1];flag5=1;}
        if(Vel>0.7&&Vel<=1.8){g5[1]=Vel*10.0/11.0-7.0/11.0;g5[0]=1-g5[1];flag5=2;}
        if(Vel>1.8&&Vel<4.5){g5[1]=Vel*10.0/27.0-2.0/3.0;g5[0]=1-g5[1];flag5=3;}
        if(flag1==3||flag2==3||flag3==3||flag4==3||flag5==3){
            if(flag1==3){c1[0]=g1[0];c2[0]=g1[1];}
            if(flag2==3){c1[1]=g2[0];c2[1]=g2[1];}
            if(flag3==3){c1[2]=g3[0];c2[2]=g3[1];}
            if(flag4==3){c1[3]=g4[0];c2[3]=g4[1];}
            if(flag5==3){c1[4]=g5[0];c2[4]=g5[1];}
            p[0]=c1[0];p[1]=c2[0];
            for(i=1;i<5;i++){
                if(p[0]>c1[i]){p[0]=c1[i];}
                if(p[1]<c2[i]){p[1]=c2[i];}                
            }
            *pCMS=(p[0]*0.6667+p[1])/(p[0]+p[1]);
        }
        else if(flag1==2||flag2==2||flag3==2||flag4==2||flag5==2){
             if(flag1==2){c1[0]=g1[0];c2[0]=g1[1];}
             if(flag2==2){c1[1]=g2[0];c2[1]=g2[1];}
             if(flag3==2){c1[2]=g3[0];c2[2]=g3[1];}
             if(flag4==2){c1[3]=g4[0];c2[3]=g4[1];}
             if(flag5==2){c1[4]=g5[0];c2[4]=g5[1];}
             p[0]=c1[0];p[1]=c2[0];
             for(i=1;i<5;i++){
                if(p[0]>c1[i]){p[0]=c1[i];}
                if(p[1]<c2[i]){p[1]=c2[i];}                
             }
             *pCMS=(p[0]*0.3333+p[1]*0.6667)/(p[0]+p[1]);
        }
        else{
             if(flag1==1){c1[0]=g1[0];c2[0]=g1[1];}
             if(flag2==1){c1[1]=g2[0];c2[1]=g2[1];}
             if(flag3==1){c1[2]=g3[0];c2[2]=g3[1];}
             if(flag4==1){c1[3]=g4[0];c2[3]=g4[1];}
             if(flag5==1){c1[4]=g5[0];c2[4]=g5[1];}
             p[0]=c1[0];p[1]=c2[0];
             for(i=1;i<5;i++){
                if(p[0]>c1[i]){p[0]=c1[i];}
                if(p[1]<c2[i]){p[1]=c2[i];}                
             }
             *pCMS=(p[1]*0.3333)/(p[0]+p[1]);
        }
  }        
}