/* This file has been prepared for Doxygen **************************/

/*! \file stepper.c *****************************************************
*
* \brief This module supports ...
*
* Copyright (C) 2008 W.Nijs (ALF4all)
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program. If not, see <http://www.gnu.org/licenses/>.
*
* \author    W.Nijs.
* \date        12/03/2009
* \version    1.0 12/03/2009, initial revision.
* \version    2.0 28/05/2010, prepared for Doxygen.
*
*********************************************************************/

/*********************************************************************
* Include section
*  Add all #defines here
*********************************************************************/

#include "mbed.h"
#include "types.h"
#include "stepper.h"


/*********************************************************************
* Global stepper vars
*********************************************************************/

int stepper_position;


/*****************************************************************//**
* \brief    stepper_init
*
* This function supports a simple counting delay.
*
* \author    W.Nijs.
* \date        28-05-2010
*********************************************************************/

void stepper_init(void) {
  stepper_position = 0;
}


/*****************************************************************//**
* \brief    stepper_step
*
* This function supports a simple counting delay.
*
* \author    W.Nijs.
* \date        28-05-2010
* \param    mode        (enum step_mode) Stepper mode (wave, full and half)
* \param    direction    (enum step_dir) Stepper direction (cw or ccw)
*********************************************************************/

BusOut stepper(LED1, LED2, LED3, LED4);

void stepper_step(enum step_mode mode, enum step_dir direction) {

  const uint8 stepper_table[3][8] = {
    // wave-drive (1.0 power 1.0 torque)
    {0x01, 0x01, 0x02, 0x02, 0x04, 0x04, 0x08, 0x08},
    // full-step (2.0 power 1.4 torque)
    {0x03, 0x03, 0x06, 0x06, 0x0C, 0x0C, 0x09, 0x09},
    // half-step (no constant power/torque)
    {0x01, 0x03, 0x02, 0x06, 0x04, 0x0C, 0x08, 0x09}
  };

  switch (direction) {
  case reverse:
    stepper_position--;
    break;
  case halt:
    break;
  case forward:
    stepper_position++;
    break;
  }
  stepper = stepper_table[mode][(stepper_position) % 8];

}
