/* This file has been prepared for Doxygen **************************/

/*! \file main.c *****************************************************
*
* \brief Test program for ATMEGA8L-trainer and the compiler chain
* Using modules: delay and stepper 
*
* Copyright (C) 2008 W.Nijs (ALF4all)
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*
* \author    W.Nijs.
* \date        12/03/2009
* \version    1.0 12/03/2009, initial revision.
* \version    2.0 28/05/2010, prepared for Doxygen.
*
*********************************************************************/

/*****************************************************************//**
* Include section
*  Add all #includes here
*********************************************************************/

#include "mbed.h"
#include "stepper.h"


/*****************************************************************//**
* \brief    main
*
* Testprogram for heartbeat-0. Making use of a LED on PC0.
*
* \author    W.Nijs.
* \date        28-05-2010
*********************************************************************/

int main() {
  int i;

  stepper_init();
  
  while(1) {
    for (i=0; i<50; i++) {
      stepper_step(half_step,forward);
       wait(0.1);
    };

    for (i=0; i<50; i++) {
      stepper_step(half_step,reverse);
       wait(0.1);
    };
  };
  return 0;
};
