/* This file has been prepared for Doxygen **************************/

/*! \file types.h ****************************************************
*
* \brief This file defines al types
*
* Copyright (C) 2008 W.Nijs (ALF4all)
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program. If not, see <http://www.gnu.org/licenses/>.
*
* \author	W.Nijs.
* \date		12/03/2009
* \version	1.0 12/03/2009, initial revision.
* \version	2.0 28/05/2010, prepared for Doxygen.
*
*********************************************************************/

/***************************************************
* Define section
*  Add all #defines here
***************************************************/

#ifndef TYPES_H_
#define TYPES_H_

typedef unsigned char	uint8;		// vorzeichenlose 8-Bit-Zahl
typedef signed char		int8;		// vorzeichenbehaftete 8-Bit-Zahl

typedef unsigned int	uint16;		// vorzeichenlose 16-Bit-Zahl
typedef short int		int16;		// vorzeichenbehaftete 16-Bit-Zahl

typedef unsigned long	uint32;		// vorzeichenlose 32-Bit-Zahl
typedef signed long		int32;		// vorzeichenbehaftete 32-Bit-Zahl

#define word			uint16		// 16 bits integer

#define True			1			// True
#define False			0			// False
	
#define On				1			// On
#define Off				0			// Off

//#define PI			3.14159		// Pi for trigonometric calculations

#define binary(var,bit) ((var >> bit)&1)

//#define NULL			0

#endif

