/* This file has been prepared for Doxygen **************************/

/*! \file stepper.h *****************************************************
*
* \brief This module supports ...
*
* Copyright (C) 2008 W.Nijs (ALF4all)
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program. If not, see <http://www.gnu.org/licenses/>.
*
* \author	W.Nijs.
* \date		12/03/2009
* \version	1.0 12/03/2009, initial revision.
* \version	2.0 28/05/2010, prepared for Doxygen.
*
*********************************************************************/

/*********************************************************************
* Define section
*  Add all #defines here
*********************************************************************/

#ifndef _STEPPER_H
#define _STEPPER_H

enum step_mode {
  wave_drive,
  full_step,
  half_step
};

enum step_dir {
  reverse,
  halt,
  forward
};


/*****************************************************************//**
* \brief	stepper_init
*
* This function supports a simple counting delay.
*
* \author	W.Nijs.
* \date		28-05-2010
*********************************************************************/

void stepper_init(void);


/*****************************************************************//**
* \brief	stepper_step
*
* This function supports a simple counting delay.
*
* \author	W.Nijs.
* \date		28-05-2010
* \param	mode		(enum step_mode) Stepper mode (wave, full and half)
* \param	direction	(enum step_dir) Stepper direction (cw or ccw)
*********************************************************************/

void stepper_step(enum step_mode mode, enum step_dir direction);

#endif
