/* This file has been prepared for Doxygen **************************/

/*! \file delay.c *****************************************************
*
* \brief This module supports a simple (performance spoiling)
* counting delay for use between mainprogram staps.
*
* <B>Attention:</B> Optimization for this module should be -O0
*
* Copyright (C) 2008 W.Nijs (ALF4all)
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program. If not, see <http://www.gnu.org/licenses/>.
*
* \author    W.Nijs.
* \date        12/03/2009
* \version    1.0 12/03/2009, initial revision.
* \version    2.0 28/05/2010, prepared for Doxygen.
*
*********************************************************************/

/*********************************************************************
* Define section
*  Add all #defines here
*********************************************************************/

#define counts_per_ms 30000    // for mbed NXP LPC1768


/*****************************************************************//**
* \brief    delay
*
* This function supports a simple counting delay.
*
* \author    W.Nijs.
* \date        28-05-2010
* \param    ms        (int) Delaytime in millieseconds
*********************************************************************/

void delay(int ms) {
    int count;

    while (ms) {
        count = counts_per_ms;
        while (count)
            count--;
        ms--;
    }
}
