#include "mbed.h"
#include "HIDScope.h"
//#include "QEI.h"
#include "MODSERIAL.h"
//#include "BiQuad.h"
//#include "FastPWM.h"

//Define objects
AnalogIn    emg0( A0 );
AnalogIn    emg1( A1 );

DigitalOut led(LED_RED);

MODSERIAL pc(USBTX, USBRX);
HIDScope    scope( 2 );

void sample()
{
    /* Set the sampled emg values in channel 0 (the first channel) and 1 (the second channel) in the 'HIDScope' instance named 'scope' */
    scope.set(0, emg0.read() );
    scope.set(1, emg1.read() );
    /* Repeat the step above if required for more channels of required (channel 0 up to 5 = 6 channels) 
    *  Ensure that enough channels are available (HIDScope scope( 2 ))
    *  Finally, send all channels to the PC at once */
    scope.send();
    /* To indicate that the function is working, the LED is toggled */
    led = !led;
}

int main()
{
    pc.baud(115200);
    pc.printf("\r\nStarting...\r\n\r\n");
    
    while (true) {
        
        led = !led;
        sample();
        wait_ms(500);
    }
}
