#include "mbed.h"
#include "WIZnetInterface.h"

Serial uart(USBTX, USBRX);  // UART2 Debug PA2, PA3
SPI spi(PA_7, PA_6, PA_5);  // MOSI, MISO, SCLK
WIZnetInterface  eth(&spi, PB_6, PA_9); // SPI, CS, reset

unsigned char MAC_Addr[6] = {0x00,0x01,0x00,0x00,0x00,0x00};
UDPSocket socket;
Endpoint client;


PwmOut stepper(PB_4);       // Тактовый сигнал на ШД
DigitalOut enable(PB_3);    // Включение ШД 
DigitalOut direction(PB_5); // Направление вращения ШД


#define MSG_BUF_LEN   50
char msg[MSG_BUF_LEN];
char *msgPtr = msg;

int main() {
    
    int returnCode = 0;
    char *ip;
    int udpPackLength = 0;
    
    /* Используем UART для вывода отладочной информации */
    uart.baud(115200);
    
    /* Настройки SPI для Ethernet shield */
    spi.format(8,0);
    spi.frequency(8000000);
    wait(1);
   
    /* Инициализация Ethernet, попытка получить IP по DHCP */   
    printf("Initializing Ethernet\r\n");
    returnCode = eth.init(MAC_Addr); 
    if ( returnCode == 0 )
    {
        printf(" - Ethernet ready\r\n");
        printf("Ethernet.connecting...\r\n");
        returnCode = eth.connect();
        printf(" - connecting returned %d \r\n", returnCode);
        printf("Trying to get IP address..\r\n");
        ip = eth.getIPAddress();
        printf(" - IP address: %s\r\n", ip);
    }
    else
        printf(" - Could not initialize Ethernet\r\n");
  
    /* В модуле Socket.cpp в конструкторе можно настроить режзим работы сокета (блокирующий/неблокирующий)
       и настроить timeout ожидания. Сейчас настроил неблокирующий режим, timeout = 300 ms */  
    socket.init();
    socket.bind(80);
    
    
    enable = 1;
    stepper.period(0.005f);
    stepper.write(0.50f);
  
   
    while(1) 
    {
        udpPackLength = socket.receiveFrom(client, msg, MSG_BUF_LEN);
        
        if (udpPackLength != -1)
        {
            printf("UDP received data: ");
            printf(msg);
            printf("\r\n");
            socket.sendTo(client, msg, udpPackLength);  // Эхо
            memset(msg, 0, MSG_BUF_LEN);    
        }
        
        wait_ms(1000);
    }
}


