//this defines motor setup and movement
#include "mbed.h"
#include "pins.cpp"
//will have to determine real pulsewidths by testing with encoder
//constants to be utilized in the buggy, can be changed as required
#define NORMAL_PWM 0.2f
#define FAST_PWM 0.7f
#define SLOW_PWM 0.3f
#define RIGHT_MOTOR_CONST 1
#define LEFT_MOTOR_CONST 1
#define MOTOR_PERIOD 1.0f
//currently the setup uses unipolar mode, hence the need for direction


void motorSetup(){
    motorRight.period_ms(MOTOR_PERIOD);
    motorLeft.period_ms(MOTOR_PERIOD);
    motorDirLeft.write(1);
    motorDirRight.write(1);
    motorModeLeft.write(1);
    motorModeRight.write(1);
    driveBoard.write(1);
}
void buggyGoF(){ //drives forward
    motorRight.write(NORMAL_PWM);
    motorLeft.write(NORMAL_PWM);
}

void buggyGoLeft(){// drives left
    motorRight.write(FAST_PWM);
    motorLeft.write(SLOW_PWM);
}
void buggyGoRight(){ //drives fast
    motorRight.write(SLOW_PWM);
    motorLeft.write(FAST_PWM);
}
void buggyStop(){// no power
    motorRight.write(0.0f);
    motorLeft.write(0.0f);
}
