#include "mbed.h"
#include "C12832.h"

C12832 lcd(D11, D13, D12, D7, D10);

AnalogIn pot1 (A0);
AnalogIn pot2 (A1);
//sensors pin
AnalogIn SRI (PC_4);
AnalogIn SLI (PC_2);
AnalogIn SRO (PB_1);
AnalogIn SLO (PC_5);
//AnalogIn SC (PB_0);
AnalogIn SM (PC_3);
//motor pin
PwmOut motorRight(PC_6);
PwmOut motorLeft(PC_8);
DigitalOut motorDirRight(PH_1);
DigitalOut motorDirLeft(PH_0);
DigitalOut motorModeRight(PC_15);
DigitalOut motorModeLeft(PC_14);
DigitalOut driveBoard (PB_2);

void turnArround();

void motorSetup(){
    motorRight.period_ms(1.0f);
    motorLeft.period_ms(1.0f);
    motorDirLeft.write(0);
    motorDirRight.write(0);
    motorModeLeft.write(0); //1 =bipolar, 0 = unipolar
    motorModeRight.write(0); 
    driveBoard.write(1); //enables the buggy to drive
}

int main()
{
    float SRIV, SLIV, SROV, SLOV, SMV;
    float kp=0.07125,ki=0.0,kd=0.02875;
    float error1, error2, error3,error,perror=0,errort=0, pidvalue;
    float pr, pl;
    
    motorSetup();
    lcd.cls();
    //motorRight.write(1.0f);
    //motorLeft.write(1.0f);
    
    
    while(1){
        /*lcd.locate(0,3);
        lcd.printf("LeftO= %.2fV/ RightO= %.2fV", (float)SLO*3.30, (float)SRO*3.30);
        lcd.locate(0,13);
        lcd.printf("LeftI= %.2fV/ RightI= %.2fV", (float)SLI*3.30, (float)SRI*3.30);
        lcd.locate(0,23);
        lcd.printf("Magn= %.2fV",  (float)SM *3.30);*/
        
        SLOV=(float)SLO*3.30;
        SLIV=(float)SLI*3.30;
        SRIV=(float)SRI*3.30;
        SROV=(float)SRO*3.30;
        SMV=(float)SM *3.30;
        
        error1=SLOV-SROV;
        error2=SLIV-SRIV;
        error=error1+error2;
        //errort+=error;
        pidvalue=kp*error+kd*(error-perror)+ki*errort;
        
        if ((SMV>2.7f)||(SMV<0.6f)) turnArround();
        motorRight.write(0.72f-pidvalue);
        motorLeft.write(0.7411f+pidvalue);
        
        pr=motorRight.read();
        pl=motorLeft.read();
        
        lcd.locate(0,3);
        lcd.printf("pr:%.4fV pl:%.4fV", pr, pl);
        lcd.locate(0,13);
        lcd.printf("e1= %.4fV/ e2= %.4fV", error1, error2);
        perror=error;
        pidvalue=0;
        
    }
    
}

void turnArround(){ //turns us around
     motorRight.write(1.0f);
     motorLeft.write(1.0f);
     wait(3);
     motorDirLeft.write(1);
     motorDirRight.write(0);
     motorRight.write(0.8f);
     motorLeft.write(0.8f);
     wait(3);
     motorDirLeft.write(0);
    }
