#include "mbed.h"
#include "QEI.h"
#include "pins.h"
#include "constants.cpp"


//these lines setup the encoders for both wheels

//main wheel class, the subclasses should follow later
class Wheel{
    int currentPulses, previousPulses;
    public:
        float velocity(int wheelPulses){
            return encoderVelocity(wheelPulses)*GEAR_RATIO;
        }
    private:
        float encoderVelocity(int encoderPulse){
            wait(SAMPLE_TIME);
            previousPulses=currentPulses;
            currentPulses=encoderPulse;
            return (currentPulses-previousPulses)/SAMPLE_TIME;
        }

} wheelRight, wheelLeft;

//call this for speed, linear and angular
class Buggy{
    public:
        float speedLinear(int pulseRight, int pulseLeft){
            return (wheelRight.velocity(pulseRight)+wheelLeft.velocity(pulseLeft))/2;
            }
        float speedAngular(int pulseRight, int pulseLeft){
            return (wheelRight.velocity(pulseRight)-wheelLeft.velocity(pulseLeft))/WHEEL_DISTANCE;
            }
    }buggy;
    //temp functions to get the encoder speed
int encoderVelocityLeft(){
    return wheelLeft.velocity(encoderLeft.getPulses());
    }
int encoderVelocityRight(){
    return wheelRight.velocity(encoderRight.getPulses());
    }