#include "mbed.h"
#include "pwm.h"
#include "pins.h"
#include "constants.cpp"
#include "C12832.h"
#include "encoderBase.h"

void buggyGoLeft();
void buggyGoF();
void buggyGoRight();
void buggyStop();

void controlAutomatic(int flag){ //this is a showoff version
    while(flag==1){
    wait(0.5);
    buggyGoF();
    wait(2);
    buggyGoLeft();
    wait(2);
    buggyGoRight();
    wait(2);
    buggyStop();
    }
}
void controlManual(int flag){
    while (1){ //this function is for manual wheel turnage using the potentiometers. Knock yourself out
    while(1){
       if(joystickDown!=0) break;
       
       float rightPWM= (float)potentiometerRight.read() ;
       float leftPWM= (float)potentiometerLeft.read();
       lcd.locate(0,3);
       lcd.printf("L=%d;    R=%d", encoderVelocityLeft(), encoderVelocityRight());
       //wait(2);
       lcd.cls();
    buggyPWM(leftPWM ,rightPWM);
    }
    wait(0.5);
    buggyGoF();
    wait(1);
    buggyGoLeft();
    wait(2);
    buggyGoRight();
    wait(2);
    buggyGoF();
    wait (1);
    buggyStop();
    }
    }
    
    
void stateMachine(int flag){
    while (1){ //depending on the flag  changes the state. Not efficient, since relies on looping the whole thing, but will do for now
    switch(flag){
        case 0: controlManual(flag);
        case 1:controlAutomatic(flag);
                break;
        }
        }
    }
void buggyGoLeft(){
    buggyPWM(SLOW_PWM, FAST_PWM);
    }
void buggyGoRight(){
    buggyPWM(FAST_PWM, SLOW_PWM);
    }
void buggyGoF(){
    buggyPWM(NORMAL_PWM, NORMAL_PWM);
    }
void buggyStop(){
    buggyPWM(0.0f, 0.0f);
    }