
#include "mbed.h"
#include "Serial_HL.h"
#include "FuncGenFSST.h"
 
SerialBLK pc(USBTX, USBRX);
SvProtocol ua0(&pc);

SignedRampGen fg1;
RectGen rg1;



float ampl1 = 1.0;
float ampl2 = 0.5;
float v1 = 0; // signal nach dem Verstellen der Amplidute
float v2 = 0;


void CommandHandler();

void ExecSignalChain(); // Signalverarbeitungskette 1x durchrechen

int main(void)
{
	pc.format(8,SerialBLK::None,1); pc.baud(115200); // 115200
	ua0.SvMessage("FuncGen"); // Meldung zum PC senden
	
	Timer stw; stw.start();
	while(1)
	{
		CommandHandler();
		
		if( (stw.read_ms()>10) ) // 100Hz
	    { // dieser Teil wird mit 100Hz aufgerufen
			ExecSignalChain();
	      	stw.reset();
			if( ua0.acqON ) 
			{
				ua0.WriteSV(1, v1); // v1 anzeigen
				ua0.WriteSV(2, v2); // v1 anzeigen
			}
	    }
	}
	return 1;
}

// wird mit 100Hz (Analyse) oder 44kHz (Echtzeit) aufgerufen
void ExecSignalChain()
{
	fg1.CalcOneStep();
	v1 = fg1.val*ampl1;
	
	rg1.CalcOneStep();
	v2 = rg1.val*ampl2;
	//v1 = rg1.val_orginal*ampl2;
}

void CommandHandler()
{
  uint8_t cmd;
	if( !pc.IsDataAvail() )
    	return;
    	
	cmd = ua0.GetCommand();
	
	if( cmd==2 ) // Set Frequ.
	{
		fg1.SetFrequ(ua0.ReadF());
		ua0.SvMessage("Set Frequ1");
	}
	
	if( cmd==3 ) // Set ampl
	{
		ampl1 = ua0.ReadF();
		ua0.SvMessage("Set Ampl1");
	}
	
	if( cmd==4 ) // Set Frequ2
	{
		rg1.SetFrequ(ua0.ReadF());
		ua0.SvMessage("Set Frequ2");
	}
	
	if( cmd==5 ) // Set ampl2
	{
		ampl2 = ua0.ReadF();
		ua0.SvMessage("Set Ampl2");
	}
}

















