
#include "FuncGenFSST.h"

 
RectGen::RectGen()
{
	val=0;
	SetPointsPerPeriod(20);
}

void RectGen::SetPointsPerPeriod(int aPoints)
{
	_inc = 2.0/aPoints;
}

void RectGen::SetFrequ(float aFrequ)
{
	SetPointsPerPeriod(1.0/aFrequ);
}

void RectGen::CalcOneStep()
{
	_phase = _phase + _inc;
	if( _phase>1.0 )
    _phase = -1 + (_phase - 1.0); 
    val_orginal = _phase;
    
    if(_phase > 0)
    	val = 1;
    else
    	val = -1;
}



SignedRampGen::SignedRampGen()
{
	val=0;
	SetPointsPerPeriod(20);
}

void SignedRampGen::SetPointsPerPeriod(float aPoints)
{
	_inc = 2.0/aPoints;
}

void SignedRampGen::SetFrequ(float aFrequ)
{
	SetPointsPerPeriod(1.0/aFrequ);
}

void SignedRampGen::CalcOneStep()
{
	val = val + _inc;
	if( val>1.0 )
    val = -1 + (val - 1.0); 
}
















