//相互通信確認用
//modify to ASCII
#include "mbed.h"
#define BUFFER 30
#include <string> 
#include <cstdlib>

Serial rs485(PA_9,PA_10);//,115200);//(p9,p10);
Serial pc(USBTX,USBRX);
DigitalOut Receiver(D7);//(p5);
  
float cnv;
 
unsigned int CRC_Verify(unsigned char *cBuffer, unsigned int iBufLen);
void setAddress(char MotorAddress,int16_t DataAddress,int16_t Data);

#define LENG 31   //0x42 + 31 bytes equal to 32 bytes
#define APR 0x0066  //0066H means encoder abs rev
unsigned char buffer[LENG];
//attributes - program variables
char stringOverSerialBuffer[41];    // buffer to store received string over pc
int newCommandFlag = 0;             // flag for ISR
int len;
int a,b;
char data[BUFFER];
char num[16];
int dataH,datanum;
char recChar=0;
char recArr[20];
int index=0;
int idx;
bool recFlag=false;
unsigned int CRC_Verify(unsigned char *cBuffer, unsigned int iBufLen)
{
    unsigned int i, j;
    //#define wPolynom 0xA001
    unsigned int wCrc = 0xffff;
    unsigned int wPolynom = 0xA001;
    /*---------------------------------------------------------------------------------*/
    for (i = 0; i < iBufLen; i++)
    {
        wCrc ^= cBuffer[i];
        for (j = 0; j < 8; j++)
        {
            if (wCrc &0x0001)
            {
                wCrc = (wCrc >> 1) ^ wPolynom;
            }
            else
            { 
                wCrc = wCrc >> 1;
            }
        }
    }
    return wCrc;
}
int str2int(const char* str, int star, int end)
{
    int i;
    int ret = 0;
    for (i = star; i < end+1; i++)
    {
        ret = ret *10 + (str[i] - '0');
    }
    return ret;     
}
// functions
void flushSerialBuffer() { 
    while (rs485.readable()) { 
        rs485.getc(); 
    } 
}
void readData() 
{
    while (rs485.readable()) 
    {
        recChar = rs485.getc();
        recArr[index] = recChar;
        index++;
        if ((recChar == '\r') || (index>18)) 
        {
            datanum = str2int(recArr,1,2);
            if (datanum == 1)
            {
                dataH = str2int(recArr,7,10);
                pc.printf("M1 = %d\r\n",dataH);
            }
            else
            {
                pc.printf("M1 = no data\r\n");
            }
            
            if (datanum == 2)
            {
                dataH = str2int(recArr,7,10);
                pc.printf("M2 = %d\r\n",dataH);
            }
            else
            {
                pc.printf("M2 = no data\r\n");
            }
                    
            recArr[index] = 0;
            index = 0;
            //pc.printf("%s\r\n", recArr);  

            flushSerialBuffer();
            recFlag = true;
        }
    }
}


void setAddress(char MotorAddress,int16_t DataAddress,int16_t Data)
{
    unsigned char sendData[16];
    //int DataAddress,Data;
    char DataAddressH,DataAddressL;

    int i;

    Receiver = 1;
    wait_ms(1);
    DataAddressH = ((DataAddress>>8)&0xFF);
    DataAddressL = ((DataAddress>>0)&0xFF);

    
    //sendData[0] = Header;//MotorAddress;
    sendData[0] = MotorAddress;
    sendData[1] = 0x03;
    sendData[2] = DataAddressH;
    sendData[3] = DataAddressL;
    sendData[4] = Data>>8;
    sendData[5] = (Data&0xFF);
        
    sendData[6] = sendData[0]+sendData[1]+sendData[2]+sendData[3]+sendData[4]+sendData[5];
    sendData[6] = (~sendData[6]+1);
    rs485.printf(":");
    for (i=0;i<7;i++)
    {
        rs485.printf("%02X",sendData[i]);
    }
    wait_ms(1);
    Receiver = 0;
    wait_ms(10);        //give 10ms let receive complete.
}  
int i;
bool timeout=false;
int WDindex = 0;
int main()
{
    rs485.baud(38400);
    pc.baud(115200);

    Receiver=0;
    rs485.attach(&readData);
    while(1)
    {
        recFlag = false;
//        setAddress(1,0x0214,0x0001);
//        setAddress(2,0x0214,0x0001);        
        setAddress(1,APR,0x0001);
        setAddress(2,APR,0x0001);
//        while (recFlag == false || timeout == false) 
//        {
//            if(WDindex<100)
//            {
//                WDindex++;
//                wait_ms(1);
//            }
//            else
//            {
//                WDindex = 0;
//                timeout = true;
//            }
//        }
    }
}