#include "mbed.h"
#include "TS_DISCO_F746NG.h"
#include "LCD_DISCO_F746NG.h"

LCD_DISCO_F746NG lcd;
TS_DISCO_F746NG ts;
InterruptIn button1(D0);
AnalogIn Ain(A0);
TS_StateTypeDef TS_State;
Serial pc(USBTX, USBRX);
void button1pressed() {
    wait(0.5);
    lcd.Clear(LCD_COLOR_BLACK);
    NVIC_SystemReset();
}

int main() 
{
pc.baud(9600);
pc.format(8, SerialBase::None, 1); //default
float high, high1,  low, low1; //in_tune, in_tune1, in_tune2, in_tune3;
int note;
float Buffer[12005];;
float PI=3.1415;
int SAMPLE_RATE = 24000;
float goertzelFilter4;
char rac;
int in;
///////////////////////////////////////////////////////
////////////////////
//Interupt for Switching Strings
    button1.mode(PullDown);
    button1.rise(&button1pressed);
    int Counter = 0;
    lcd.Clear(LCD_COLOR_BLACK);
    lcd.SetBackColor(LCD_COLOR_DARKGREEN);
    lcd.SetTextColor(LCD_COLOR_YELLOW);
    //
    lcd.SetTextColor(LCD_COLOR_RED);
    lcd.FillRect(1,1,20,20);
    //AntiHead
    lcd.SetTextColor(LCD_COLOR_LIGHTBLUE);
    lcd.FillCircle(111,112,27);
    lcd.FillCircle(111,160,27);
    lcd.FillCircle(116,85,9);
    lcd.FillCircle(116,187,9);
    //Head
    lcd.SetTextColor(LCD_COLOR_LIGHTBLUE);
    lcd.FillRect(114,70,100,133);
    lcd.FillRect(205,76,57,120);
    lcd.FillRect(262,70,100,133);
    lcd.FillRect(262,70,100,133);
    lcd.SetTextColor(LCD_COLOR_BLACK);
    lcd.FillCircle(362,70,25);
    lcd.FillCircle(362,203,25);
    lcd.SetBackColor(LCD_COLOR_LIGHTBLUE);
    lcd.SetTextColor(LCD_COLOR_RED);
    lcd.DisplayStringAt(0,LINE(5),(uint8_t*)"GOERTZELY-disco",CENTER_MODE);
    lcd.SetTextColor(LCD_COLOR_WHITE);
    lcd.FillRect(362,95,12,84);
    lcd.SetTextColor(LCD_COLOR_BROWN);
    lcd.FillRect(374,95,106,84);
    lcd.SetTextColor(LCD_COLOR_LIGHTGRAY);
    lcd.FillRect(426,95,4,84);
    lcd.FillCircle(400,137,8);
    lcd.FillCircle(452,137,8);
    //TuningSlot
    lcd.SetTextColor(LCD_COLOR_LIGHTGRAY); //TOP
    lcd.FillRect(298,50,9,20);
    lcd.FillRect(236,54,9,22);
    lcd.FillRect(174,50,9,20);
// //Bottom
    lcd.FillRect(298,203,9,20);
    lcd.FillRect(236,196,9,22);
    lcd.FillRect(174,203,9,20);
    
    lcd.SetTextColor(LCD_COLOR_YELLOW);
    lcd.FillRect(277,15,52,35);//E4
    lcd.FillRect(215,19,52,37);//B3
    lcd.FillRect(153,15,52,35);//G3
    lcd.FillRect(277,223,52,35);//E2
    lcd.FillRect(215,216,52,37);//A2
    lcd.FillRect(153,223,52,35);//D3
    
    //Note
    lcd.SetBackColor(LCD_COLOR_YELLOW);
    lcd.SetTextColor(LCD_COLOR_BLACK);
    lcd.DisplayStringAt(278,23,(uint8_t*)"G3",RIGHT_MODE);
    lcd.DisplayStringAt(216,29,(uint8_t*)"B3",RIGHT_MODE);
    lcd.DisplayStringAt(154,23,(uint8_t*)"E4",RIGHT_MODE);
    
    lcd.DisplayStringAt(278,229,(uint8_t*)"D3",RIGHT_MODE);
    lcd.DisplayStringAt(216,223,(uint8_t*)"A2",RIGHT_MODE);
    lcd.DisplayStringAt(154,229,(uint8_t*)"E2",RIGHT_MODE);


    while (note<50) {
        ts.GetState(&TS_State);
        if(((TS_State.touchX[0]>277)&&(TS_State.touchX[0]<329))
        &&((TS_State.touchY[0]>223)&&(TS_State.touchY[0]<258))) //6
        {
            lcd.SetTextColor(LCD_COLOR_RED);
            lcd.FillRect(277,223,52,35);
            lcd.SetBackColor(LCD_COLOR_RED);
            lcd.SetTextColor(LCD_COLOR_BLACK);
            lcd.DisplayStringAt(154,229,(uint8_t*)"E2",RIGHT_MODE);
            note = 82;
            rac = 'E';
            in = 2;
    
            }
        if(((TS_State.touchX[0]>215)&&(TS_State.touchX[0]<267))
        &&((TS_State.touchY[0]>216)&&(TS_State.touchY[0]<253))) //5
        {
            lcd.SetTextColor(LCD_COLOR_RED);
            lcd.FillRect(215,216,52,37);
            lcd.SetBackColor(LCD_COLOR_RED);
            lcd.SetTextColor(LCD_COLOR_BLACK);
            lcd.DisplayStringAt(216,223,(uint8_t*)"A2",RIGHT_MODE);
            note = 110;
            rac = 'A';
            in = 2;
    
            }
        if(((TS_State.touchX[0]>153)&&(TS_State.touchX[0]<205))
        &&((TS_State.touchY[0]>223)&&(TS_State.touchY[0]<258))) //4
        {
            lcd.SetTextColor(LCD_COLOR_RED);
            lcd.FillRect(153,223,52,35);
            lcd.SetBackColor(LCD_COLOR_RED);
            lcd.SetTextColor(LCD_COLOR_BLACK);
            lcd.DisplayStringAt(278,229,(uint8_t*)"D3",RIGHT_MODE);
            note = 147;
            rac = 'D';
            in = 3;
            }
        if(((TS_State.touchX[0]>153)&&(TS_State.touchX[0]<205))
        &&((TS_State.touchY[0]>15)&&(TS_State.touchY[0]<50))) //3
        {
            lcd.SetTextColor(LCD_COLOR_RED);
            lcd.FillRect(153,15,52,35);
            lcd.SetBackColor(LCD_COLOR_RED);
            lcd.SetTextColor(LCD_COLOR_BLACK);
            lcd.DisplayStringAt(278,23,(uint8_t*)"G3",RIGHT_MODE);
            note = 196;
            rac = 'G';
            in = 3;
            }
        if(((TS_State.touchX[0]>215)&&(TS_State.touchX[0]<267))
        &&((TS_State.touchY[0]>19)&&(TS_State.touchY[0]<56))) //2
        {
            lcd.SetTextColor(LCD_COLOR_RED);
            lcd.FillRect(215,19,52,37);
            lcd.SetBackColor(LCD_COLOR_RED);
            lcd.SetTextColor(LCD_COLOR_BLACK);
            lcd.DisplayStringAt(216,29,(uint8_t*)"B3",RIGHT_MODE);
            note = 247;
            rac = 'B';
            in = 3;
            }
        if(((TS_State.touchX[0]>277)&&(TS_State.touchX[0]<329))
        &&((TS_State.touchY[0]>15)&&(TS_State.touchY[0]<50))) //1
        {
            lcd.SetTextColor(LCD_COLOR_RED);
            lcd.FillRect(277,15,52,35);
            lcd.SetBackColor(LCD_COLOR_RED);
            lcd.SetTextColor(LCD_COLOR_BLACK);
            lcd.DisplayStringAt(154,23,(uint8_t*)"E4",RIGHT_MODE);
            note = 330;
            rac = 'E';
            in = 4;
            }
        }
        
        wait(0.5);
    

while(1){////// mother while ///////////////////

lcd.Clear(LCD_COLOR_LIGHTRED);
    lcd.SetBackColor(LCD_COLOR_LIGHTRED);
    lcd.SetTextColor(LCD_COLOR_BLACK);
    lcd.DisplayStringAt(0, LINE(6), (uint8_t *)"...1...", CENTER_MODE);
    wait(1);
    lcd.Clear(LCD_COLOR_LIGHTRED);
    lcd.SetBackColor(LCD_COLOR_LIGHTRED);
    lcd.SetTextColor(LCD_COLOR_BLACK);
    lcd.DisplayStringAt(0, LINE(6), (uint8_t *)"...2...", CENTER_MODE);
    wait(1);
    lcd.Clear(LCD_COLOR_LIGHTRED);
    lcd.SetBackColor(LCD_COLOR_LIGHTRED);
    lcd.SetTextColor(LCD_COLOR_BLACK);
    lcd.DisplayStringAt(0, LINE(6), (uint8_t *)"...3...", CENTER_MODE);
    wait(1);

button1.mode(PullDown);
button1.rise(&button1pressed);   
Counter = 0; 
lcd.Clear(LCD_COLOR_RED);
for(int i=0;i<10000;i=i+1)
    {
    Buffer[i] = Ain.read();
    Counter = Counter+1;
    char str[20],con[20];
    lcd.SetBackColor(LCD_COLOR_RED);
    lcd.SetTextColor(LCD_COLOR_BLACK);
    sprintf(con," Please Keep Picking : %c%d ",rac,in);
    lcd.DisplayStringAt(0, LINE(4), (uint8_t *)con, CENTER_MODE);
    sprintf(str,"We did  %d  sample",Counter);
    lcd.DisplayStringAt(0, LINE(6), (uint8_t *)str, CENTER_MODE);
    wait_us(42);
    }

/////////////////CALCULATION//////////
high = 0;
low = 0;
////HIGH//////
            
for (int i=3; i<46; i+=3) 
{
    float freq = note + i; 
    int N = Counter;
    float s_prev = 0.0;
    float s_prev2 = 0.0;
    float coeff,normalizedfreq,s;
    normalizedfreq = freq / SAMPLE_RATE;
    coeff = 2*cos(2*PI*normalizedfreq);
    for (int i=0; i<=N ; i=i+1) {
        s = Buffer[i] + coeff * s_prev - s_prev2;
        s_prev2 = s_prev;
        s_prev = s;
    }
    float goertzelFilter1 = s_prev2*s_prev2+s_prev*s_prev-coeff*s_prev*s_prev2;
    high1 = goertzelFilter1;
    if (high1 > high) 
    {
    high=high1;
    }
}
    //lcd.Clear(LCD_COLOR_BLACK);
    //lcd.SetBackColor(LCD_COLOR_BLACK);
    //lcd.SetTextColor(LCD_COLOR_RED);
    //lcd.DisplayStringAt(0, LINE(6), (uint8_t *)"...1...", CENTER_MODE);
    wait(0.1);
////LOW//////
for (int i=3; i<46; i+=3) 
{     
    float freq = note - i; 
    int N = Counter;
    float s_prev = 0.0;
    float s_prev2 = 0.0;
    float coeff,normalizedfreq,s;
    normalizedfreq = freq / SAMPLE_RATE;
    coeff = 2*cos(2*PI*normalizedfreq);
    for (int i=0; i<=N ; i=i+1) {
        s = Buffer[i] + coeff * s_prev - s_prev2;
        s_prev2 = s_prev;
        s_prev = s;
    }
    float goertzelFilter2 = s_prev2*s_prev2+s_prev*s_prev-coeff*s_prev*s_prev2;
    low1 = goertzelFilter2;
    if (low1 > low) 
    {
    low=low1;
    }
}
   // lcd.Clear(LCD_COLOR_BLACK);
    //lcd.SetBackColor(LCD_COLOR_BLACK);
    //lcd.SetTextColor(LCD_COLOR_RED);
    //lcd.DisplayStringAt(0, LINE(6), (uint8_t *)" ..2.. ", CENTER_MODE);
    wait(0.1);
    
    /////////goertzelFilter3/////////////
    float freq = note + 1; 
    int N = Counter;
    float s_prev = 0.0;
    float s_prev2 = 0.0;
    float coeff,normalizedfreq,s;
    normalizedfreq = freq / SAMPLE_RATE;
    coeff = 2*cos(2*PI*normalizedfreq);
    for (int i=0; i<=N ; i=i+1) 
    {
        s = Buffer[i] + coeff * s_prev - s_prev2;
        s_prev2 = s_prev;
        s_prev = s;
    }
    float goertzelFilter3 = s_prev2*s_prev2+s_prev*s_prev-coeff*s_prev*s_prev2;
    
    //lcd.Clear(LCD_COLOR_BLACK);
    //lcd.SetBackColor(LCD_COLOR_BLACK);
    //lcd.SetTextColor(LCD_COLOR_RED);
    //lcd.DisplayStringAt(0, LINE(6), (uint8_t *)"...3...", CENTER_MODE);
    wait(0.1);
            
    /////////goertzelFilter4/////////////
    freq = note ; 
    N = Counter;
    s_prev = 0.0;
    s_prev2 = 0.0;
    normalizedfreq = freq / SAMPLE_RATE;
    coeff = 2*cos(2*PI*normalizedfreq);
    for (int i=0; i<=N ; i=i+1){
        s = Buffer[i] + coeff * s_prev - s_prev2;
        s_prev2 = s_prev;
        s_prev = s;
    }
    goertzelFilter4 = s_prev2*s_prev2+s_prev*s_prev-coeff*s_prev*s_prev2;
    //lcd.Clear(LCD_COLOR_BLACK);
    //lcd.SetBackColor(LCD_COLOR_BLACK);
    //lcd.SetTextColor(LCD_COLOR_RED);
    //lcd.DisplayStringAt(0, LINE(6), (uint8_t *)" ..4.. ", CENTER_MODE);
    wait(0.1);

    
    /////////goertzelFilter5/////////////
    //freq = note - 1; 
   // N = Counter;
   // s_prev = 0.0;
   // s_prev2 = 0.0;
   // normalizedfreq = freq / SAMPLE_RATE;
   // coeff = 2*cos(2*PI*normalizedfreq);
    //for (int i=0; i<=N ; i=i+1){
    //    s = Buffer[i] + coeff * s_prev - s_prev2;
    //    s_prev2 = s_prev;
    //    s_prev = s;
    //}
    //float goertzelFilter5 = s_prev2*s_prev2+s_prev*s_prev-coeff*s_prev*s_prev2;
   // lcd.Clear(LCD_COLOR_BLACK);
    //lcd.SetBackColor(LCD_COLOR_BLACK);
    //lcd.SetTextColor(LCD_COLOR_RED);
    //lcd.DisplayStringAt(0, LINE(6), (uint8_t *)"...5...", CENTER_MODE);
   // wait(0.4);
    
     
        //in_tune1 =  goertzelFilter3;
        //in_tune2 =  goertzelFilter4;
        //in_tune3 =  goertzelFilter5;
        
       // if ((in_tune1 > in_tune2) && (in_tune1 > in_tune3)) 
        //{in_tune = in_tune1;}
       // else if ((in_tune2 > in_tune1) && (in_tune2 > in_tune3)) 
        //{in_tune = in_tune2;}
        //else {in_tune = in_tune3;}
        //printf("high = %.2f, low = %.2f, in_tune = %.2f", high, low, in_tune);
       
        
        //if ((in_tune > high) && (in_tune > low)) {
          //  lcd.Clear(LCD_COLOR_GREEN);
          //  lcd.SetBackColor(LCD_COLOR_GREEN);
           // lcd.SetTextColor(LCD_COLOR_BLACK);
           // lcd.DisplayStringAt(0,LINE(5),(uint8_t*)"NOW INTUNE!!!!",CENTER_MODE);
            //wait(1.5);
       // } 
        //else if (high > in_tune) {
           // lcd.Clear(LCD_COLOR_RED);
            //wait(1.5);} 
        //else if (low > in_tune) {
          //  lcd.Clear(LCD_COLOR_BLUE);
          //  wait(1.5);} 
       // else{}
       
     lcd.Clear(LCD_COLOR_YELLOW);
    lcd.SetBackColor(LCD_COLOR_YELLOW);
    lcd.SetTextColor(LCD_COLOR_RED);
    char str1[20],str2[20],str3[20];
    sprintf(str1," Relative Magnitude ");
    lcd.DisplayStringAt(0, LINE(3), (uint8_t *)str1, CENTER_MODE);
    sprintf(str3," Note : %c%d ",rac,in);
    lcd.DisplayStringAt(0, LINE(5), (uint8_t *)str3, CENTER_MODE);
    sprintf(str2," %f ",goertzelFilter4);
    lcd.DisplayStringAt(0, LINE(7), (uint8_t *)str2, CENTER_MODE);
    wait(4);
    }

}