#include "mbed.h"
#include "DebouncedIn.h"

LocalFileSystem local("local");

DigitalOut SysLiveLED(LED1);    //LED blinking to tell operator that system is live
DigitalOut TestLED1(LED2);      //TestLED
DigitalOut TestLED2(LED3);      //TestLED
DigitalOut UpRelay(p21);        //Relay controlling valve to move actuator towards gear up position         !!TBC for PWM out!!
DigitalOut DownRelay(p22);      //Relay controllinig calve to move actuator towards gear down position      !!TBC for PWM out!!
DebouncedIn ChangeDown(p16);    //Debounced class creating digital input to invoke a gear change down
DebouncedIn ChangeUp(p15);      //Debounced class creating digital input to invoke a gear change up
AnalogIn Position(p20);         //Analogue input to read current position of actuator from POT
CAN CAN1(p9, p10);              //create CAN inteface under the name CAN1
//PID Actuator(0.4312, 0.1, 0.0, 0.01);  //(Kc, Ti, Td, Interval) PID class for control of actuator


Ticker SysLive;                 //create Ticker SysLive to blink SysLiveLED


static char ID4_data[8] = {0};      //ID4_data is identifier 0x2003 data containing - Gear, Advance (x10), Injection (x10), Fuel Con L/100km (x10)
static char ID3_data[8] = {0};      //ID3_data is identifier 0x2002 data containing - Fuel Kpa, Oil temp C, Volts x 10, Fuel Con. L/Hr (x10)
static char ID2_data[8] = {0};      //ID2_data is identifier 0x2001 data containing - MAP Kpa, Lamda (x100), KPH x 10, Oil P Kpa
static char ID1_data[8] = {0};      //ID2_data is identifier 0x2001 data containing - RPM, TPS %, Water Temp C  , Air Temp C
//static int LookUp[2,100] {0};     //2D look up table of two columns (2 PWM ouputs) and 100??? rows (0-100 percent) to change PID value into desired PWM output
char CurrentGear = 0;
int i = 0;


void SysLive_ISR(void);
void ReadGear(void);
void ChangeGearUp(void);
void ChangeGearDown(void);
void ChangeGearNeutral(void);

int main() 
{
SysLive.attach(SysLive_ISR, 0.1);   //create Ticker                      
CAN1.frequency(1000000);

DownRelay = 1;
UpRelay = 1;

static CANMessage ID4 = CANMessage(0x2003, ID4_data, 8, CANData, CANExtended);
static CANMessage ID3 = CANMessage(0x2002, ID3_data, 8, CANData, CANExtended);
static CANMessage ID2 = CANMessage(0x2001, ID2_data, 8, CANData, CANExtended);
static CANMessage ID1 = CANMessage(0x2000, ID1_data, 8, CANData, CANExtended);

    while(1)
    {
    if(ChangeUp.falling())
        {
        TestLED1 = 1;
        wait(0.1);
        TestLED1 = 0;
         switch (CurrentGear)
            {
            case 0:
            case 1:
            case 2:
            case 3:
            case 4:
            case 5:
            ChangeGearUp();
            break;
            case 6:
            CurrentGear--;
            break;
            }//end up change switch
        CurrentGear = CurrentGear++;
        }// end up change if
        
    if(ChangeDown.falling())
        {
        TestLED2 = 1;
        wait(0.1);
        TestLED2 = 0;
        switch (CurrentGear)
            {
            case 6:
            case 5:
            case 4:
            case 3:
            case 2:
            ChangeGearDown();
            break;
            case 1:
            ChangeGearNeutral();
            break;
            case 0:
            CurrentGear++;
            break;
            }//end down change switch
        CurrentGear = CurrentGear--;
        }// end down change if
        
    }//end while loop
}//end program

/*

*/
void SysLive_ISR()
{
    SysLiveLED = !SysLiveLED;
}

void ChangeGearUp(void)
{
/*
Testing boring stuff
    UpRelay = 0;
    wait(0.2);
    UpRelay = 1;
    DownRelay = 0;
    wait(0.2);
    DownRelay = 1;
*/
    //Actuator.setSetPoint(GearUpEndPoint)
    //while((Position != GearUpEndPoint))
        //{
        //update current process value i.e. call the Actuator.setProcessValue(fabs(Position));
        //Actuator.compute();
        //Call the PWM output to reflect the new desired PID value by look up this PID value (%) against the lookup table
        //}
    //Actuator.setSetPoint(GearCentral)
    //while((Position != GearCentral))
        //{
        ////update current process value i.e. call the Actuator.setProcessValue(fabs(Position));
        //Actuator.compute();
        //Call the PWM output to reflect the new desired PID value by look up this PID value (%) against the lookup table
        //}
}

void ChangeGearDown(void)
{
/*
    DownRelay = 0;
    wait(0.2);
    DownRelay = 1;
    UpRelay = 0;
    wait(0.2);
    UpRelay = 1;
*/
    //Actuator.setSetPoint(GearDownEndPoint)
    //while((Position != GearDownEndPoint))
        //{
        //update current process value i.e. call the Actuator.setProcessValue(fabs(Position));
        //Actuator.compute();
        //Call the PWM output to reflect the new desired PID value by look up this PID value (%) against the lookup table
        //}
    //Actuator.setSetPoint(GearCentral)
    //while((Position != GearCentral))
        //{
        ////update current process value i.e. call the Actuator.setProcessValue(fabs(Position));
        //Actuator.compute();
        //Call the PWM output to reflect the new desired PID value by look up this PID value (%) against the lookup table
        //}
}

void ChangeGearNeutral(void)
{
    while (Position!=0.744)
    {
        UpRelay = 0;
        wait_ms(1);
        UpRelay = 1;
        wait_ms(9);
    }
}


void ReadGear()
{

}



//M40 south, roundabout A34 oxford, Whitchurch, past Station Road go down Dancers Lane, left through overton, oakley come to oakley hall, on right pack lane after big white house, crossroads straight across, 