#include "mbed.h"
#include "FastPWM.h"

#define TOGGLE   1
#define TOGGLE2  2
#define TOGGLE3  4

// GPIO
Serial pc(USBTX, USBRX);
AnalogIn VoltageSense(A0);
AnalogIn CurrentSense(A1);
FastPWM fastpwm(D6,1);

//Function declarations
void SamplingFunction();
void PrintAverage();
void FindMPP();

//Variables
double Voltage;
double VoltageA;
double VoltageB;
double VoltageC;
double NewVoltage;
double OldVoltage;

double Current;
double CurrentA;
double CurrentB;
double CurrentC;

double Power = 0;
double PowerA;
double PowerB;
double PowerC;

double NewPower;
double OldPower = 20;
double DutyCycle = 0.05;
double DutyMPP;
double OldPower2 = 0;
double test1;
double test2;
double test3;
double testT;



Thread t1, t2, t3;

osThreadId id1;
osThreadId id2;
osThreadId id3;


Ticker T; 
Ticker T2; 

void doISR() {
           t1.signal_set(TOGGLE);
            }
             
             
void doISR2() {
             t2.signal_set(TOGGLE2);
             }             

void SamplingFunction() {
    Thread::signal_wait(TOGGLE3);
        while (true) {

            VoltageA= VoltageSense;
            CurrentA = CurrentSense;
            PowerA   = Voltage*Current;
            VoltageB = VoltageSense;
            CurrentB = CurrentSense;
            PowerB   = Voltage*Current;
            VoltageC = VoltageSense;
            CurrentC = CurrentSense;
            PowerC   = Voltage*Current;
            
            Voltage = VoltageA+VoltageB+VoltageC;
            Voltage = Voltage/3;
            
            Current = CurrentA+CurrentB+CurrentC;
            Current = Current/3;
            
            Power = PowerA+PowerB+PowerC;
            Power = Power/3;
            
            NewVoltage = Voltage;
            NewPower = Power;
            if (NewPower > OldPower){
                
                if (NewVoltage > OldVoltage){
                    DutyCycle = DutyCycle-0.001; 
                } else { 
                    DutyCycle = DutyCycle+0.01; 
                }
                
            }else{
                 
                 if (NewVoltage > OldVoltage){
                    DutyCycle = DutyCycle+0.001; 
                } else {
                    DutyCycle = DutyCycle-0.001; 
                }   
                
             } //Close if
              if (DutyCycle > 0.5){
                  DutyCycle = 0.5;
                  }
              if (DutyCycle < 0.05){
                  DutyCycle = 0.05;
                  }
              OldPower = NewPower;
              OldVoltage = NewVoltage;
              fastpwm.write(DutyCycle);
              wait(0.1);
    }   // Close While
} // Close Function

void FindMPP(){

    DutyCycle = 0.05;
        wait(0.1);
    for (int a = 0; a < 90; ++a){
            
            Voltage = VoltageSense;
            Current = CurrentSense;
            Power   = Voltage*Current;
            test1 = Power;
            wait(0.001);
            Voltage = VoltageSense;
            Current = CurrentSense;
            Power   = Voltage*Current;
            test2 = Power;
            wait(0.001);
            Voltage = VoltageSense;
            Current = CurrentSense;
            Power   = Voltage*Current;
            test3 = Power;
            
        if (test1 > testT){
            testT = test1;
            DutyMPP = DutyCycle;
            }
        if (test2 > testT){
            testT = test2;
            DutyMPP = DutyCycle;
            }
        if (test3 > testT){
            testT = test3;
            DutyMPP = DutyCycle;
            }
    DutyCycle = DutyCycle+0.005;        
    fastpwm.write(DutyCycle);
            
    wait(0.2);
    }
    DutyCycle = DutyMPP;
    fastpwm.write(DutyCycle);
    t3.signal_set(TOGGLE3);
  }          

void PrintAverage(){
    
    while (true) {        
        Thread::signal_wait(TOGGLE2);   
        pc.printf("V = %f,I = %f, P = %f, D = %f, DutyMPP = %f\n\r", Voltage*3.3*7.09, Current*3.3*0.1, Power*11.5, DutyCycle, DutyMPP);
     //   pc.printf("P = %f, t1 = %f, t2 = %f,t3 = %f, tT = %fDuty = %f, DutyMPP = %f\n\r", Power*11.5, test1*11.5, test2*11.5, test3*11.5, testT*11.5, DutyCycle, DutyMPP);  
        }    
} 
   
int main()

    {     
    
    
    
           fastpwm.period_us(10);           // 100kHz period
           fastpwm.write(DutyCycle);        //20% dutyCycle
        

  
    //Attach timer to run Interupt every 15 seconds.
    T.attach(&doISR, 0.00005);
    T2.attach(&doISR2, 0.1);
    
    // Start thread 1.   Find MPP
    t1.start(FindMPP); // adding data to queue.

    // Start thread 2.  Printing to Serial
    t2.start(PrintAverage); // Printing sampled data to LCD.
     
    // Start thread 3. Sampling MPP
    t3.start(SamplingFunction);
    
    }

