// Trafic Light Program
//
// HND Electronics
//
// Coleg Gwent

#include "mbed.h"


//Traffic Lights
// R,Y,G  R,Y,G
BusOut leds(p5,p6,p7,p8,p9,p10);

// 7 seg Display
BusOut disp1(p11,p12,p13,p14,p15,p16,p17);
//           A   B   C   D   E   F   G

// 7 seg Dispay
BusOut disp2(p21,p22,p23,p24,p25,p26,p27);
//           A   B   C   D   E   F   G


//Test Leds - for debugging
DigitalOut myLED1(LED1);
DigitalOut myLED2(LED2);



int valdisp =0;

//using MAN74A seven seg display
//set up each number in an array
int numb[10][7]={{1,1,1,1,1,1,0},
                {0,1,1,0,0,0,0},
                {1,1,0,1,1,0,1},
                {1,1,1,1,0,0,1},
                {0,1,1,0,0,1,1},
                {1,0,1,1,0,1,1},
                {1,0,1,1,1,1,1},
                {1,1,1,0,0,0,0},
                {1,1,1,1,1,1,1},
                {1,1,1,1,0,1,1}};
  
                
//Traffic light sequence
int nLights[] = {0x09,0x19,0x21,0x11,0x09,0x0B,0x0C,0x0A};
                
                
// Switch inputs
DigitalIn  man(p28);
DigitalIn  dir(p29);


// Analog input to set time
AnalogIn timeIn(p19);

int state;

int waitTime = 0;

void displayWait() {
    
                     waitTime = timeIn*99;      
                    
                    // display number UNITS
                    for (int i = 0 ;i < 7; i++) 
                        { 
                        disp2[i]=(numb[waitTime%10][i]);
                        }
                     // display number TENS
                    for (int i = 0 ;i < 7; i++) 
                        { 
                        disp1[i]=(numb[waitTime/10][i]);
                        }
    }

int main() {
    while(1) {
                       
           while(man)
            { // in Manual mode
                                
                if (dir){
                    // Direction 1
                        wait(1);
                        leds = nLights[1]; //RED, RED AMBER
                        wait(1);
                        leds = nLights[2]; //RED, GREEN
                // Stay on Green until direction changed or Automode selected
                while (dir && man){displayWait();  }
                    leds = nLights[3]; //RED, RED AMBER
                       wait(1);
                    // set the state to 4 for the AUTO routine   
                    state=4;   
                    }
                    else
                    {
                    // Direction 2    
                        wait(1);
                        leds = nLights[5]; //RED AMBER, RED 
                        wait(1);
                        leds = nLights[6]; //GREEN, GREEN
                
                // Stay on Green until direction changed or Automode selected
                while (!dir && man){displayWait();  }
                 leds = nLights[7]; //RED AMBER, RED 
                        wait(1);
                        // set the state to 0 for the AUTO routine
                     state=0;  
                    }
             displayWait();         
             leds = nLights[0]; //Always go to Red Red when not in loop       
             wait(timeIn *9); // wait on Red for road distance wait
            }  
            
         while (!man) {
               // if in AUTO mode 
               // In AUTO mode sequence through the lights
              leds = nLights[state];
              displayWait();      
              if (state%2 == 0) wait(waitTime/10); //Only long Waits on Even states
              wait(1);
              state++;
              if (state==8) state=0;
            }
            
            // While Auto loop over now in manual
    }
}
