#include "mbed.h"
#include "epd1in54.h"

Serial serial(USBTX, USBRX,115200);                 //Local terminal Baud rate 

//E-ink Display
PinName rst; PinName dc; PinName busy; PinName mosi; PinName miso; PinName sclk; PinName cs;
unsigned char frame_black[EPD_HEIGHT*EPD_WIDTH/8];
Epd epd = Epd(PB_5, PB_4, PB_3, PA_8, PC_4, PC_7, PB_10);

double liquidTemp = 0;
double ambientTemp = 0;
char cValt[32];

int Display(double t)
{
Epd epd = Epd(PB_5, PB_4, PB_3, PA_8, PC_4, PC_7, PB_10);
    
    sprintf(cValt,"%.2f", t);    
    memset(frame_black, 0xFF, sizeof(unsigned char)*EPD_HEIGHT*EPD_WIDTH/8);
    if (epd.Init(lut_full_update) != 0) {
        return -1;
    }
    //Write strings to the buffer 
    epd.DrawStringAt(frame_black, 0, 50, cValt, &Font72, COLORED);
   
    // Display the frame_buffer 
    epd.SetFrameMemory(frame_black, 0, 0, epd.width, epd.height);
    epd.DisplayFrame();
    epd.Sleep();
    return 1;
    }







int main() {

    while(1) {
        serial.printf("SystemCoreClock is %d Hz...........\r\n", SystemCoreClock); 
        wait(2);
        
            ambientTemp = 20.0;
            printf("Ambient Temperature %3.1foC\r\n", ambientTemp);
            liquidTemp = 20.5;
            printf("liquid Temperature %3.1foC\r\n", liquidTemp);
            Display(ambientTemp);
            wait(2); //little delay to prevent double writing
    }
}
