#include "TimerSubscriber.h"

struct TimerSubscriber::TimerEntry *TimerSubscriber::TimerTable = NULL;
unsigned int TimerSubscriber::TableSize = 0;
unsigned int TimerSubscriber::TickerCounter = 1;

static Ticker timer;
extern TimerSubscriber timer_user;

TimerSubscriber::TimerSubscriber(const unsigned int inTableSize, const unsigned int inTickerPeriod) : 
    TickerPeriod(inTickerPeriod)
{
    TableSize = inTableSize;
    TimerTable = new TimerEntry[TableSize];
    for (int i=0; i<TableSize; i++) 
        TimerTable[i].CallBack = NULL;
    TickerCounter = 0;
    timer.attach_us(&OnTimer, TickerPeriod);  
    
    return;  
}

TimerSubscriber::~TimerSubscriber()
{
    delete[] TimerTable;
}

void TimerSubscriber::OnTimer(void)
{
    for (int i=0; i<TableSize; i++)
        if (NULL != TimerTable[i].CallBack)
            if (0 == --TimerTable[i].Counter)
            {
                TimerTable[i].CallBack->TimerEvent();
                TimerTable[i].Counter = TimerTable[i].Divider;
            };
    TickerCounter++;
}

bool TimerSubscriber::Subscribe(class TimerDependent *adres, const unsigned int inDivider)
{
    for (int i=0; i<TableSize; i++)
        if (NULL == TimerTable[i].CallBack)
        {
            TimerTable[i].CallBack = adres;
            TimerTable[i].Divider = inDivider;
            TimerTable[i].Counter = inDivider;
            return true;
        }
    return false;
}

bool TimerSubscriber::UnSubscribe(const class TimerDependent *adres)
{
    for (int i=0; i<TableSize; i++)
        if (adres == TimerTable[i].CallBack)
        {
            TimerTable[i].CallBack = NULL;
            return true;
        }
    return false;
}

//---------------------------------------------------------------------------------------
//  class TimerDependent
//---------------------------------------------------------------------------------------

TimerDependent::TimerDependent()
{
}

TimerDependent::~TimerDependent()
{
}

