#pragma once
#include "mbed.h"

/*-------------------------------------------------------------

(c) W.D. 2014

-------------------------------------------------------------*/

/*  ------ sample usage------
#include "TimerSubscriber.h"

TimerSubscriber timer_user(10, 10000); // 10 in table, 10ms period

class TimerUsing : TimerDependent
{
public:
    TimerUsing();
    {
        timer_user.Subscribe (this, 10);
    };
    virtual ~TimerUsing() 
    {
        timer_user.UnSubscribe(this);
    };
    virtual void TimerEvent(void) 
    {
    };
}

};

TimerUsing TimerUsingClass;

main ()
{
}

*/
class TimerDependent
{
public:
    TimerDependent();
    virtual ~TimerDependent();
    
    virtual void TimerEvent (void) = NULL;
};

class TimerSubscriber 
{
public:
    TimerSubscriber(const unsigned int inTableSize=10, const unsigned int inTickerPeriod=10000);
    ~TimerSubscriber();
    inline unsigned int counter_rd(void) {return TickerCounter;};
    inline unsigned int TickerPeriod_rd(void) {return TickerPeriod;};
    bool Subscribe(class TimerDependent *adres, const unsigned int inDivider=1);
    bool UnSubscribe(const class TimerDependent *adres);
private:
    static struct TimerEntry
    {
        class TimerDependent *CallBack;
        unsigned int Divider;
        unsigned int Counter;
    } *TimerTable;
    static void OnTimer(void);
    static unsigned int TableSize;
    unsigned int TickerPeriod;
    static unsigned int TickerCounter;
};
