#pragma once
#include "mbed.h"
#include "TimerSubscriber.h"

/*-------------------------------------------------------------

(c) W.D. 2014

Usage example

#include "TimeCounter.h"

TimerSubscriber timer_user(10, 1000); // 10 in table, 1ms period
TimeCounter time_counter;

main()
{
    long int Second = time_counter.ReadSeconds();
}
-------------------------------------------------------------*/

/*  ------ sample usage------
*/

extern TimerSubscriber timer_user;

class TimeCounter : TimerDependent
{
public:
    TimeCounter();
    virtual ~TimeCounter();
    inline long int ReadSeconds(void){return this->ticks / this->TicksPerSecond;};
    inline long int ReadTicks(void){return ticks;};
    inline void SetSeconds(long int InSeconds){this->ticks = InSeconds * this->TicksPerSecond;};
    virtual void TimerEvent(void);
private:
    long long int ticks;
    int TicksPerSecond;
};
  