#pragma once
#include "mbed.h"
#include "TimerSubscriber.h"

/*-------------------------------------------------------------

(c) W.D. 2014

-------------------------------------------------------------*/

/*  ------ sample usage------
*/
#define SAMPLES_TO_DEBOUNCE 64

extern TimerSubscriber timer_user;

class DigitalInDebounced : TimerDependent
{
public:
    DigitalInDebounced(const PinName pin, const unsigned int inDebounceTime=300);
    DigitalInDebounced(const PinName pin, const PinMode mode, const unsigned int inDebounceTime=300);
    virtual ~DigitalInDebounced();
    bool read(void);
    inline bool is_stable(void) {return stable;};
    inline bool current_state(void) {return Switch->read();};
    inline unsigned int rd_PreDivider (void) {return PreDivider;};
    inline unsigned int rd_Divider (void) {return Divider;};
    inline unsigned int rd_DebounceTime (void) {return DebounceTime;};
    inline unsigned int rd_DebounceCounter (void) {return DebounceCounter;};
    virtual void TimerEvent(void);
private:
    bool recent;
    bool stable;
    DigitalIn *Switch;
    unsigned int PreDivider;
    unsigned int Divider;
    unsigned int DebounceTime;
    unsigned int DebounceCounter;
    void DigitalInDebounced_common(DigitalIn *SwitchIn, const unsigned int inDebounceTime);
};
  