#pragma once

#include "SLCD.h"

/*-------------------------------------------------------------

(c) W.D. 2014

-------------------------------------------------------------*/

/*  ------ sample usage------
Convert slcd;

    while (true) 
    {
        wait(1.);
        slcd.display(99999);            //  OFL
        wait(2.);
        slcd.display(9999);             //  9999
        wait(1.);
        slcd.display(-999);             //  -999
        wait(1.);
        slcd.display(-99999);           // -OFL
        wait(2.);
        slcd.display(99999.0);          //  OFL
        wait(1.);
        slcd.display(1234.5);           // 1000
        wait(1.);
        slcd.display(234.5);            // 200.0
        wait(1.);
        slcd.display(34.56);             // 30.00
        wait(1.);
        slcd.display(4.567);              // 4.000
        wait(1.);
        slcd.display((float)0.56789);       // 0.500
        wait(1.);
        slcd.display((double)0.0);      //     0
        wait(1.);
        slcd.display((float)-0.67890);      // -0.60
        wait(1.);
        slcd.display((double)-7.891);     // -7.00
        wait(1.);
        slcd.display((float)-89.123);    // -80.0
        wait(1.);
        slcd.display((double)-912.34);   // -900
        wait(1.);
        slcd.display(-12345.0);  // -OFL
        wait(1.);
    }
*/

class Convert : public SLCD
{
public: 
    Convert();
    bool display(unsigned int number);
    bool display(int number);
    bool display(double number);
    bool display(float number);
    bool display(char *text);
private:
    void display_digits(unsigned int number, bool negate=false);
    void prepare(void);
};
