#include"mbed.h"
#include "Serial.h"
#include"RS485_usrlib.h"

RS485::RS485(PinName _tx,PinName _rx,PinName _pin):_serial(_tx,_rx),_rede(_pin){
    buffer[0]=buffer[1]=buffer[2]=buffer[3]=buffer[4]=0;
    _serial.attach(&onInterrupt,Serial::RxIrq);
}
void RS485::Transmit_data(int address,int *data){
    int TxData[5] = {0};
    
    /*データ準備*/
    TxData[0] = '#';//TAG
    TxData[1] = address;//ID
    TxData[2] = data[0];//data
    TxData[3] = data[1];//data
    TxData[4] = (TxData[0]^TxData[1]^TxData[2]^TxData[3]);
    
    /*送信*/
    _rede = 1;
    for(int i=0;i<=4;i++){
        _serial.putc(TxData[i]);
    }
    wait_us(2500);
    _rede = 0;
}

int RS485::getc(){
    return _serial.getc();
}
