/*--- 送信側 ---*/
#include "mbed.h"
#include "Serial.h"
DigitalOut led(PA_12);
DigitalOut myled(LED1);
DigitalOut rede(PA_8);

DigitalIn address1(PF_0);
DigitalIn address2(PB_1);
DigitalIn address4(PB_6);
DigitalIn address8(PB_7);

Serial myserial(PA_9,PA_10);

void send_rs485();
void onInterrupt();

int index = 0;
int buffer[5] = {0};
int address;
int main() {
    rede=0;
    address = address1<<0 | address2<<1 | address4<<2 | address8<<3;
    myserial.attach(&onInterrupt,Serial::RxIrq);
    while(1){
        if(address == 0x01){
            myled = 1;
        }else{
            myled=0;
        }
        send_rs485();
        led=1;
        wait(0.05);
        led=0;
        wait(0.05);
    }
}

void send_rs485(){
    int TxData[5] = {0};
    
    /*データ準備*/
    TxData[0] = '#';//TAG
    TxData[1] = address;//ID
    TxData[2] = 0x41;//data
    TxData[3] = 0x41;//data
    TxData[4] = (TxData[0]^TxData[1]^TxData[2]^TxData[3]);
    
    /*送信*/
    rede = 1;
    for(int i=0;i<=4;i++){
        myserial.putc(TxData[i]);
    }
    wait_us(2500);
    rede = 0;
}

void onInterrupt(){
    myled=1;
    wait(0.01);
    myled=0;
    wait(0.01);
    char data = myserial.getc();
    if(data == '#'){
        index = 1;
        return;
    }
    if(index != 0){
        buffer[index-1] = data;
        if(index == 5){
            index = 0;
        }
        index ++;
    }
}