#include "mbed.h"

DigitalOut  board_led(LED1);
BusOut leds(PB_4,PB_5,PA_11,PA_8,PF_1,PF_0,PB_1,PB_6,PB_7,PB_0);
InterruptIn up(PA_0);
InterruptIn down(PA_1);
PwmOut my_pwm(PA_12);

int count;

void pressed(){
    if(up.read() == 0){
        if(count < 10){
            count++;
        }else{
            count = 10;
        }
    }
    if(down.read() == 0){
        if(count > 0){
            count--;
        }else{
            count = 0;
        }
    }
    board_led = !board_led;
}

int main()
{
    count = 0;
    float pwm_data=0.001;
    // Set PWM
    my_pwm.period_ms(20);
    // Set button
    up.fall(&pressed);
    down.fall(&pressed);
    //mainloop
    while (1) {
        if(count == 0){
            leds = 0b0000000000;
            pwm_data = 0.0010;
        }
        if(count == 1){
            leds = 0b0000000001;
            pwm_data = 0.0011;
        }
        if(count == 2){
            leds = 0b0000000011;
            pwm_data = 0.0012;
        }
        if(count == 3){
            leds = 0b0000000111;
            pwm_data = 0.0013;
        }
        if(count == 4){
            leds = 0b0000001111;
            pwm_data = 0.0014;
        }
        if(count == 5){
            leds = 0b0000011111;
            pwm_data = 0.0015;
        }
        if(count == 6){
            leds = 0b0000111111;
            pwm_data = 0.0016;
        }
        if(count == 7){
            leds = 0b0001111111;
            pwm_data = 0.0017;
        }
        if(count == 8){
            leds = 0b0011111111;
            pwm_data = 0.0018;
        }
        if(count == 9){
            leds = 0b0111111111;
            pwm_data = 0.0019;
        }
        if(count == 10){
            leds = 0b1111111111;
            pwm_data = 0.0020;
        }
        my_pwm.pulsewidth(pwm_data);
    }
}
