#include "pixy2.h"

#define NB_FONCTIONNALITES 8

Serial pc(USBTX, USBRX, 9600);

// debug en cas d'erreur de checksum
int sommeDeControle,sommeRecue;

// Gestion appui sur BP
bool FLAG_BP = false;
int nb_appui = -1;

void appui_BP(void)
{
    if(!FLAG_BP) // pour éviter les rebonds
        nb_appui = (nb_appui+1)%NB_FONCTIONNALITES;
    FLAG_BP = true;
}

/* PROGRAMME DE TEST DES FEATURES FONCTIONNEL */

int main(void)
{
    PIXY2               maPixy(PC_12, PD_2);     // PC_12 : UART5_TX --- PD_2 : UART5_RX
    
    T_pixy2Version *version;
    T_pixy2Resolution *resolution;
    T_pixy2ReturnCode *framerate;
    T_pixy2Pixel *pixel;
    T_pixy2ErrorCode    cr;

    // Initialisations
    InterruptIn BP(USER_BUTTON);
    BP.rise(&appui_BP);

    Timer timeOut;
    timeOut.start();

    typedef enum {IDLE, SND, CHECKSUM_ERROR, TIMEOUT, OK} T_state;
    T_state etat = IDLE;

    while(1) {

        switch (etat) {
            case IDLE :
                if (FLAG_BP) {
                    pc.printf("Envoi...\n\r");
                    FLAG_BP = false;
                    timeOut.reset();
                    etat = SND;
                }
                break;
                
            case SND :
                switch(nb_appui) {
                    case 0:
                        cr = maPixy.pixy2_getVersion(&version);
                        break;
    
                    case 1:
                        cr = maPixy.pixy2_getResolution(&resolution);
                        break;
    
                    case 2:
                        cr = maPixy.pixy2_getFPS(&framerate);
                        break;
                        
                    case 3:
                        cr = maPixy.pixy2_getRGB(resolution->pixFrameWidth / 2, resolution->pixFrameHeight / 2, 0, &pixel);
                        break;
                        
                    case 4:
                        cr = maPixy.pixy2_setLED(0,0,255);
                        break;
    
                    case 5:
                        cr = maPixy.pixy2_setLamp(1,1);
                        break;
    
                    case 6:
                        cr = maPixy.pixy2_setCameraBrightness(255);
                        break;
    
                    case 7:
                        cr = maPixy.pixy2_getAllFeature(PIXY2_VECTOR | PIXY2_INTERSECTION | PIXY2_BARCODE);
                        if(cr != PIXY2_BUSY)
                        {
                            if(cr <= 7)
                            {
                                if((cr & PIXY2_VECTOR) == PIXY2_VECTOR)
                                {
                                    pc.printf("\n\r%d vecteurs detect\202s\n\r", maPixy.Pixy2_numVectors);
                                    etat = OK;
                                }
                                if((cr & PIXY2_INTERSECTION) == PIXY2_INTERSECTION)
                                {
                                    pc.printf("\n\r%d intersections detect\202es\n\r", maPixy.Pixy2_numIntersections);
                                    etat = OK;
                                }
                                if((cr & PIXY2_BARCODE) == PIXY2_BARCODE)
                                {
                                    pc.printf("\n\r%d codes barre detect\202s\n\r", maPixy.Pixy2_numBarcodes);
                                    etat = OK;
                                }
                            }
                            else if(cr > 7)
                                pc.printf("Aucune feature recue !\n\r");
                        }
                        break;
                }
    
                // Test des possibles erreurs
                if (cr == PIXY2_BAD_CHECKSUM)
                    etat = CHECKSUM_ERROR;
                else if (timeOut.read()>2.f)
                    etat = TIMEOUT;
                else if (cr == PIXY2_OK)
                    etat = OK;
                else if (cr != PIXY2_BUSY)
                    pc.printf("Valeur de retour : %d\n\r", cr);
                break;

            case OK :
                switch(nb_appui) {
                    case 0:
                        pc.printf("Version de la camera : %s\n\r", version->pixHFString);
                        break;

                    case 1:
                        pc.printf("Resolution de la camera : %d - %d\n\r", resolution->pixFrameWidth, resolution->pixFrameHeight);
                        break;
                        
                    case 2:
                        pc.printf("Framerate : %d\n\r", framerate->pixReturn);
                        break;
                        
                    case 3:
                        pc.printf("Pixel au centre de l'\202cran: R : %d, G : %d, B : %d\n\r", pixel->pixRed, pixel->pixGreen, pixel->pixBlue);
                        break;
                        
                    case 4:
                        pc.printf("Led bleue allum\202e !\n\r");
                        break;

                    case 5:
                        pc.printf("Leds blanches allum\202es !\n\r");
                        break;
                        
                    case 6:
                        pc.printf("Luminosit\202 de la camera a fond !\n\r");
                        break;

                    case 7:
                        for (int i=0; i<maPixy.Pixy2_numVectors; i++)
                        {
                            pc.printf("\n1er pt du %de vecteur : x: %d, y: %d\n\r", i+1, maPixy.Pixy2_vectors[i].pixX0, maPixy.Pixy2_vectors[i].pixY0);
                            pc.printf("2e  pt du %de vecteur : x: %d, y: %d\n\r", i+1, maPixy.Pixy2_vectors[i].pixX1, maPixy.Pixy2_vectors[i].pixY1);
                        }
                        for (int i=0; i<maPixy.Pixy2_numIntersections; i++)
                        {
                            pc.printf("\npt de l'intersection %d : x: %d, y: %d\n\r", i+1, maPixy.Pixy2_intersections[i].pixX, maPixy.Pixy2_intersections[i].pixY);
                            pc.printf("Nombre de droites sur cette intersection : %d\n\r", maPixy.Pixy2_intersections[i].pixN);
                        }
                        for (int i=0; i<maPixy.Pixy2_numBarcodes; i++)
                        {
                            pc.printf("\nCoordonn\202es du code barre %d : x: %d, y: %d\n\r", i+1, maPixy.Pixy2_barcodes[i].pixX, maPixy.Pixy2_barcodes[i].pixY);
                            pc.printf("Nombre associ\202 a ce code barre : %d\n\r", maPixy.Pixy2_barcodes[i].pixCode);
                        }
                        break;
                }
                etat = IDLE;
                break;

            case CHECKSUM_ERROR :
                pc.printf("Erreur de CheckSum...\n\r");
                pc.printf("CheckSum Recu    : %d\n\r", sommeRecue);
                pc.printf("CheckSum Calcule : %d\n\r", sommeDeControle);
                etat = IDLE;
                break;

            case TIMEOUT :
                pc.printf("Erreur Timeout...\n\rError %d\n\r", cr);
                maPixy.affDataSize();
                etat = IDLE;
                break;
        }
    }
}