#include "mbed.h"
#include "HIDScope.h"
#include "BiQuad.h"
#include "math.h"

#define IGNORECOUNT 100  // change the ignore count after the muscle is contracted

//Define objects
AnalogIn    emg0( A0 );     // EMG at A0
BiQuad emg0bq1(0.8848578, -1.7697156, 0.8848578, -1.7539023, 0.7855289); // highpass at 30Hz  Q at around 1
BiQuad emg0bq2(0.0773021,0.1546042,0.0773021,-1.3098283,0.6190368); // lowpass at 130 Hz Q at around .6
BiQuad emg0bq3(0.9556457,-1.81774618, 0.955645, -1.817746, 0.9112914); // 50 Hz notch Q at 4.5
BiQuadChain emg0bqc1; // merged chain of three filters
BiQuadChain emg0bqc2;
BiQuadChain emg0bqc3;
int     emg0Bool    = 0;        // I don't know if these NEED to be global, but when I tried to put them in they wouldn't work...
int     emg0Ignore  = 0;
double  input = 0;              // raw input
double  filtHigh = 0;           // filtered after highpass
double  filtlow = 0;            // filtered after lowpass
double  filtNotch = 0;          // filtered after notch
double  emg0filteredAbs;
Ticker      sample_timer;
HIDScope    scope( 5 );
DigitalOut  led(LED1);



void sample(){  
    input = emg0.read();
    scope.set( 0, input);
    filtHigh = emg0bqc1.step(emg0.read());
    scope.set( 1, filtHigh);
    filtlow = emg0bqc2.step(emg0.read());
    scope.set( 2, filtlow);
    filtNotch = emg0bqc3.step(emg0.read());
    scope.set( 3, filtNotch);
    emg0filteredAbs = fabs(filtNotch);
    if (emg0filteredAbs > 0.05) {  // when above threshold  set bool to 1, here can the parameters be changed using global variables
        emg0Bool = 1;
        emg0Ignore = IGNORECOUNT;   // here is the counter increased ( at 1000 Hz, this is 0.1 sec)
        }
    else if (emg0Ignore < 0){ // if the ignore-counter is down to zero, set the bool back to 0
         emg0Bool = 0;
        }
    else {
        emg0Ignore--;      // else decrease counter by one each time has passed without threshold being met
        }
    scope.set( 4, emg0Bool);
    scope.send();

}
int main()
{ 
    emg0bqc1.add( &emg0bq1 );  
    emg0bqc2.add( &emg0bq1 ).add( &emg0bq2 );
    emg0bqc2.add( &emg0bq1 ).add( &emg0bq2 ).add ( &emg0bq3 );    // combining biquad chains is done in main, before the ticker, so only once.
    sample_timer.attach(&sample, 0.001);    //ticker at 1000Hz
    /*empty loop, sample() is executed periodically*/
    while(1) {}
}