#ifndef CONSTANTS
#define CONSTANTS

PwmOut pwmpin1(D6);
PwmOut pwmpin2(D5);
AnalogIn potmeter1(A5);
AnalogIn potmeter2(A4);
DigitalIn button1(D2);
DigitalIn button2(D3);
DigitalOut directionpin1(D4);
DigitalOut directionpin2(D7);
QEI motor1(D13,D12,NC, 32);
QEI motor2(D11,D10,NC, 32);

//Define objects
AnalogIn    emg0( A0 );     // EMG at A0
BiQuad emg0bq1(0.8848578, -1.7697156, 0.8848578, -1.7539023, 0.7855289); // highpass at 30Hz  Q at around 1
BiQuad emg0bq2(0.0773021,0.1546042,0.0773021,-1.3098283,0.6190368); // lowpass at 130 Hz Q at around .6
BiQuad emg0bq3(0.9556457,-1.81774618, 0.955645, -1.817746, 0.9112914); // 50 Hz notch Q at 4.5
BiQuadChain emg0bqc; // merged chain of three filters

AnalogIn    emg1( A1 );     // EMG at A1
BiQuad emg1bq1(0.8848578, -1.7697156, 0.8848578, -1.7539023, 0.7855289); // highpass at 30Hz  Q at around 1
BiQuad emg1bq2(0.0773021,0.1546042,0.0773021,-1.3098283,0.6190368); // lowpass at 130 Hz Q at around .6
BiQuad emg1bq3(0.9556457,-1.81774618, 0.955645, -1.817746, 0.9112914); // 50 Hz notch Q at 4.5
BiQuadChain emg1bqc; // merged chain of three filters

AnalogIn    emg2( A2 );     // EMG at A2
BiQuad emg2bq1(0.8848578, -1.7697156, 0.8848578, -1.7539023, 0.7855289); // highpass at 30Hz  Q at around 1
BiQuad emg2bq2(0.0773021,0.1546042,0.0773021,-1.3098283,0.6190368); // lowpass at 130 Hz Q at around .6
BiQuad emg2bq3(0.9556457,-1.81774618, 0.955645, -1.817746, 0.9112914); // 50 Hz notch Q at 4.5
BiQuadChain emg2bqc; // merged chain of three filters

DigitalIn kill_switch(SW2); //position has to be changed
DigitalIn next_switch(SW3); //name and position should be replaced

enum position_states{PositionCalibration, EmgCalibration, Movement, KILL};
enum emg_states{EMG0, EMG1, EMG2};
position_states CurrentState;
emg_states CalibrationState;

Ticker sample_timer;
Ticker MotorsTicker;
Timer timer;

//for testing purposes
DigitalOut ledred(LED_RED);
DigitalOut ledgreen(LED_GREEN);
DigitalOut ledblue(LED_BLUE);
//MODSERIAL pc(USBTX, USBRX);
HIDScope scope(6);

bool    emg0Bool    = 0;        // I don't know if these NEED to be global, but when I tried to put them in they wouldn't work...
int     emg0Ignore  = 0;
bool    emg1Bool    = 0;
int     emg1Ignore  = 0;
bool    emg2Bool    = 0;
int     emg2Ignore  = 0;
float   Calibration0;
float   Calibration1;
float   Calibration2;

double  input = 0;              // raw input
double  filtHigh = 0;           // filtered after highpass
double  filtlow = 0;            // filtered after lowpass
double  filtNotch = 0;          // filtered after notch
double  emg0filteredAbs;

float threshold0;
float threshold1;
float threshold2;

volatile float pwm_value1 = 0.0;
volatile float pwm_value2 = 0.0;

#endif