#include "mbed.h"

Thread SHOW_THREAD;//声明一个线程
Serial ST_LINK_UART(SERIAL_TX, SERIAL_RX);//声明一个调试串口
//------------------------------------
// Hyperterminal configuration
// 9600 bauds, 8-bit data, no parity
//------------------------------------

void show_thread_func(void)
{
    ST_LINK_UART.printf("One_Min_Time_Up\n");
    fflush(stdout);
}

DigitalOut USER_LED(PA_5);

void print_thread()//线程函数
{
    while (true) 
    {
        wait(60);//线程等待调用时长
        show_thread_func();//执行操作如打印字符,后进入标准线程
    }
}

int main()
{
    ST_LINK_UART.baud(115200);//重定义波特率为115200
    ST_LINK_UART.printf("RTOS_basic_example\n");
    SHOW_THREAD.start(print_thread);//启动一个演示线程,此处演示线程操作是打印字符*
    while (true) 
    {
        USER_LED = !USER_LED;
        wait(0.5);
    }
}
