#include "r1307.h"


R1307::R1307(PinName tx_,PinName rx_): serial(tx_,rx_)
{
  //ticker.attach(this,&R1307::update,0.01);
  serial.baud(115200);
}


void R1307::update()
{
  uint8_t index;
  int16_t angle;
  int16_t rate;
  int16_t x_acc;
  int16_t y_acc;
  int16_t z_acc;
  uint8_t check_sum,recievedData[13];
  //Verify packet heading information
  while(serial.getc() != 0xAA){
    if(!serial.readable())
      return;
  }
  if(serial.getc() != 0x00)
    return;
   //Assemble data
  for(int i = 0;i < 13;i++)
  {
    recievedData[i] = serial.getc();
  }
  for(int i = 0;i < 12;i++)
  {
    check_sum += recievedData[i];
  }
  if (recievedData[12] != check_sum) return;

  index = recievedData[0];
  rate = (recievedData[1] & 0xFF) | ((recievedData[2] << 8) & 0xFF00);
  angle = (recievedData[3] & 0xFF) | ((recievedData[4]<< 8) & 0XFF00);
  x_acc = (recievedData[5] & 0xFF) | ((recievedData[6]<< 8) & 0xFF00);
  y_acc = (recievedData[7] & 0xFF) | ((recievedData[8] << 8) & 0XFF00);
  z_acc = (recievedData[9]& 0xFF) | ((recievedData[10] << 8) & 0xFF00);
  //Scale and store data
  gRate = rate / 100.0;
  gAngle = angle / 100.0;
  gX_acc = x_acc;
  gY_acc = y_acc;
  gZ_acc = z_acc;
  return;
}
