#include "MPU-9250.h"

MPU9250::MPU9250 (PinName sda, PinName scl) : i2c(sda, scl)
{
}

int MPU9250::start()
{
    i2c.frequency(400000);
    bdf[0] = 0x75;
    i2c.write(addr,bdf,1);
    i2c.read(raddr,bdf,1);
    if (bdf[0]== 0x71)
    {
        bdf[0] = 0x6b;
        bdf[1] = 0x00;
        i2c.write(addr,bdf,2);
        bdf[0] = 0x37;
        bdf[1] = 0x02;
        i2c.write(addr,bdf,2);
        return 0;
    }else{
        return 1;
    }
}

void MPU9250::read_data(int a,double *x,double *y,double *z)
{
    char data[13] = {0};
    if (a == 0) //引数aが一のときx,y,zの地磁気の強さを返すよ。(単位はuT) If a = 1 This program will return each axis's magnetometer value.(Unit is uT)
    {
        bdf[0] = 0x0A;
        bdf[1] = 0x12;
        i2c.write(maddr,bdf,2);
        bdf[0] = 0x03;
        i2c.write(maddr,bdf,1);
        i2c.read(mraddr,data,6);
        *x = (short(data[0]+data[1]<<8)*0.15);
        *y = (short(data[2]+data[3]<<8)*0.15);
        *z = (short(data[4]+data[5]<<8)*0.15);
    }else if(a == 1){
        bdf[0] = 0x0A;
        bdf[1] = 0x12;
        i2c.write(maddr,bdf,2);
        bdf[0] = 0x03;
        i2c.write(maddr,bdf,1);
        i2c.read(mraddr,data,6);
        *x = (short(data[0]+data[1]<<8)*0.15);
        *y = (short(data[2]+data[3]<<8)*0.15);
        *z = (short(data[4]+data[5]<<8)*0.15);
        *x = atan2(*x,*y);
        if(*x>=0)
        {
            *x = *x/pi*180;
        }else{
            *x = (pi+*x)/pi*180+180;
        }
    }else{
        bdf[0] = 0x3b;
        i2c.write(addr,bdf,1);
        i2c.read(raddr,data,14);
        if (a == 2)
        {
            *x = (short(data[0]<<8+data[1])*0.061);
            *y = (short(data[2]<<8+data[3])*0.061);
            *z = (short(data[4]<<8+data[5])*0.061);
        }else if(a == 3){
            *x = (short(data[8]<<8+data[9])*0.00763);
            *y = (short(data[10]<<8+data[11])*0.00763);
            *z = (short(data[12]<<8+data[13])*0.00763);
        }
    }
}
            
