#include "mbed.h"
#include "SpwfInterface.h"
#include "x_nucleo_iks01a1.h"
#include "TCPSocket.h"
#include "Servo.h"
#include "ultrasonic.h"



int distance1;
int distance;
 void dist(int distance)
{
    //put code here to happen when the distance is changed
    printf("Distance changed to %dmm\r\n", distance);
    distance1= distance;
}


ultrasonic mu(D8, D9, .1, 1, &dist);    //Set the trigger pin to D8 and the echo pin to D9
                                        //have updates every .1 seconds and a timeout after 1
                                        //second, and call dist when the distance changes
Servo myservo(D6); 
//char* ntpServerUrl = "0.ca.pool.ntp.org";
//#define IP "184.106.153.149/update"
#define IP "184.106.153.149"
char* thingSpeakUrl = "http://api.thingspeak.com/update";
char* thingSpeakKey = "5WJ5OYWTWTQX4310";

Serial pc(USBTX, USBRX);
DigitalOut myled(LED1);
/*************/
SpwfSAInterface spwf(D8, D2, false);
uint8_t id;
float value1, value2;
char buffer1[32], buffer2[32];


int http_demo(void)
{
    TCPSocket socket(&spwf);
    char buffer[256];
    char message[160];
    int err;
    printf("Sending HTTP Data to thingspeak...\r\n");

    // Open a socket on the network interface, and create a TCP connection to thingspeak
    //socket.open(&spwf);
    err=socket.connect(IP,80); // connecting to thingspeak
    if(err!=0) 
    {
      pc.printf("\r\nCould not connect to Socket, err = %d!!\r\n", err); 
      return -1;
    } else pc.printf("\r\nconnected to host server\r\n"); 
    sprintf(message,"field1=%d",distance1);
    printf("Message Length=%d\r\n",(int)strlen(message));
    sprintf(buffer,"POST /update HTTP/1.1\r\nHost: api.thingspeak.com\r\nConnection: close\r\nX-THINGSPEAKAPIKEY: %s\r\nContent-Type: application/x-www-form-urlencoded\r\nContent-Length: %d\r\n\r\n%s",thingSpeakKey,(int)strlen(message),message);
    pc.printf("Request to %s\r\n", buffer);
    int scount = socket.send(buffer, (int)strlen(buffer));
    printf("sent %d [%.*s]\r\n", scount, strstr(buffer, "\r\n")-buffer, buffer);

    // Recieve a simple http response and print out the response line
    char rbuffer[64];
    int rcount = socket.recv(rbuffer, sizeof rbuffer);
    printf("recv %d [%.*s]\r\n", rcount, strstr(rbuffer, "\r\n")-rbuffer, rbuffer);

    // Close the socket to return its memory and bring down the network interface
    socket.close();
    return 0;
}

int main() 
{
    
       
    char * ssid = "homebb@unifi";
    char * seckey = "homebb987";  
    pc.printf("\r\nReal Time Weather System\r\n");     
    pc.printf("\r\nconnecting to AP\r\n");
            
    if(spwf.connect(ssid, seckey, NSAPI_SECURITY_WPA2)) {      
        pc.printf("\r\nnow connected\r\n");
    } else {
        pc.printf("\r\nerror connecting to AP.\r\n");
        return -1;
    }   

    const char *ip = spwf.get_ip_address();
    const char *mac = spwf.get_mac_address();
    
    pc.printf("\r\nIP Address is: %s\r\n", (ip) ? ip : "No IP");
    pc.printf("\r\nMAC Address is: %s\r\n", (mac) ? mac : "No MAC"); 
    wait (3);    
    
    while(1) 
    { 
      mu.checkDistance();     //call checkDistance() as much as possible, as this is where
                                //the class checks if dist needs to be called.
                if(distance1 <55){
                    printf("ok\r\n");
      //for(float p=0; p<1.0; p += 0.99) 
       // myservo = p;
        //wait(0.2);
      http_demo();
      //x=0;y=0;z=0;
      pc.printf("Thingspeak update completed successfully\r\n");
      //buz=0;//RESET CONDITION  
      wait(10);
    }
}}